/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchUpdate</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateObjectAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchUpdateObjectAttributes.Builder, BatchUpdateObjectAttributes> {
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).getter(getter(BatchUpdateObjectAttributes::objectReference))
            .setter(setter(Builder::objectReference)).constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final SdkField<List<ObjectAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField
            .<List<ObjectAttributeUpdate>> builder(MarshallingType.LIST)
            .getter(getter(BatchUpdateObjectAttributes::attributeUpdates))
            .setter(setter(Builder::attributeUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectAttributeUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectAttributeUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_REFERENCE_FIELD,
            ATTRIBUTE_UPDATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ObjectReference objectReference;

    private final List<ObjectAttributeUpdate> attributeUpdates;

    private BatchUpdateObjectAttributes(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.attributeUpdates = builder.attributeUpdates;
    }

    /**
     * <p>
     * Reference that identifies the object.
     * </p>
     * 
     * @return Reference that identifies the object.
     */
    public ObjectReference objectReference() {
        return objectReference;
    }

    /**
     * Returns true if the AttributeUpdates property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttributeUpdates() {
        return attributeUpdates != null && !(attributeUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes update structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributeUpdates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Attributes update structure.
     */
    public List<ObjectAttributeUpdate> attributeUpdates() {
        return attributeUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(attributeUpdates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateObjectAttributes)) {
            return false;
        }
        BatchUpdateObjectAttributes other = (BatchUpdateObjectAttributes) obj;
        return Objects.equals(objectReference(), other.objectReference())
                && Objects.equals(attributeUpdates(), other.attributeUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchUpdateObjectAttributes").add("ObjectReference", objectReference())
                .add("AttributeUpdates", attributeUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        case "AttributeUpdates":
            return Optional.ofNullable(clazz.cast(attributeUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateObjectAttributes, T> g) {
        return obj -> g.apply((BatchUpdateObjectAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchUpdateObjectAttributes> {
        /**
         * <p>
         * Reference that identifies the object.
         * </p>
         * 
         * @param objectReference
         *        Reference that identifies the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * Reference that identifies the object.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        /**
         * <p>
         * Attributes update structure.
         * </p>
         * 
         * @param attributeUpdates
         *        Attributes update structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates);

        /**
         * <p>
         * Attributes update structure.
         * </p>
         * 
         * @param attributeUpdates
         *        Attributes update structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeUpdates(ObjectAttributeUpdate... attributeUpdates);

        /**
         * <p>
         * Attributes update structure.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ObjectAttributeUpdate>.Builder} avoiding
         * the need to create one manually via {@link List<ObjectAttributeUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ObjectAttributeUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeUpdates(List<ObjectAttributeUpdate>)}.
         * 
         * @param attributeUpdates
         *        a consumer that will call methods on {@link List<ObjectAttributeUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeUpdates(List<ObjectAttributeUpdate>)
         */
        Builder attributeUpdates(Consumer<ObjectAttributeUpdate.Builder>... attributeUpdates);
    }

    static final class BuilderImpl implements Builder {
        private ObjectReference objectReference;

        private List<ObjectAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateObjectAttributes model) {
            objectReference(model.objectReference);
            attributeUpdates(model.attributeUpdates);
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final Collection<ObjectAttributeUpdate.Builder> getAttributeUpdates() {
            return attributeUpdates != null ? attributeUpdates.stream().map(ObjectAttributeUpdate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(ObjectAttributeUpdate... attributeUpdates) {
            attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<ObjectAttributeUpdate.Builder>... attributeUpdates) {
            attributeUpdates(Stream.of(attributeUpdates).map(c -> ObjectAttributeUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeUpdates(Collection<ObjectAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        @Override
        public BatchUpdateObjectAttributes build() {
            return new BatchUpdateObjectAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
