/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachTypedLinkResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<AttachTypedLinkResponse.Builder, AttachTypedLinkResponse> {
    private static final SdkField<TypedLinkSpecifier> TYPED_LINK_SPECIFIER_FIELD = SdkField
            .<TypedLinkSpecifier> builder(MarshallingType.SDK_POJO).getter(getter(AttachTypedLinkResponse::typedLinkSpecifier))
            .setter(setter(Builder::typedLinkSpecifier)).constructor(TypedLinkSpecifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkSpecifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPED_LINK_SPECIFIER_FIELD));

    private final TypedLinkSpecifier typedLinkSpecifier;

    private AttachTypedLinkResponse(BuilderImpl builder) {
        super(builder);
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
    }

    /**
     * <p>
     * Returns a typed link specifier as output.
     * </p>
     * 
     * @return Returns a typed link specifier as output.
     */
    public TypedLinkSpecifier typedLinkSpecifier() {
        return typedLinkSpecifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typedLinkSpecifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachTypedLinkResponse)) {
            return false;
        }
        AttachTypedLinkResponse other = (AttachTypedLinkResponse) obj;
        return Objects.equals(typedLinkSpecifier(), other.typedLinkSpecifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttachTypedLinkResponse").add("TypedLinkSpecifier", typedLinkSpecifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypedLinkSpecifier":
            return Optional.ofNullable(clazz.cast(typedLinkSpecifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachTypedLinkResponse, T> g) {
        return obj -> g.apply((AttachTypedLinkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, AttachTypedLinkResponse> {
        /**
         * <p>
         * Returns a typed link specifier as output.
         * </p>
         * 
         * @param typedLinkSpecifier
         *        Returns a typed link specifier as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier);

        /**
         * <p>
         * Returns a typed link specifier as output.
         * </p>
         * This is a convenience that creates an instance of the {@link TypedLinkSpecifier.Builder} avoiding the need to
         * create one manually via {@link TypedLinkSpecifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedLinkSpecifier.Builder#build()} is called immediately and its
         * result is passed to {@link #typedLinkSpecifier(TypedLinkSpecifier)}.
         * 
         * @param typedLinkSpecifier
         *        a consumer that will call methods on {@link TypedLinkSpecifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typedLinkSpecifier(TypedLinkSpecifier)
         */
        default Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return typedLinkSpecifier(TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier).build());
        }
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private TypedLinkSpecifier typedLinkSpecifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachTypedLinkResponse model) {
            super(model);
            typedLinkSpecifier(model.typedLinkSpecifier);
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return typedLinkSpecifier != null ? typedLinkSpecifier.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        @Override
        public AttachTypedLinkResponse build() {
            return new AttachTypedLinkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
