/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachToIndexRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<AttachToIndexRequest.Builder, AttachToIndexRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachToIndexRequest::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<ObjectReference> INDEX_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).getter(getter(AttachToIndexRequest::indexReference))
            .setter(setter(Builder::indexReference)).constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexReference").build()).build();

    private static final SdkField<ObjectReference> TARGET_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).getter(getter(AttachToIndexRequest::targetReference))
            .setter(setter(Builder::targetReference)).constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            INDEX_REFERENCE_FIELD, TARGET_REFERENCE_FIELD));

    private final String directoryArn;

    private final ObjectReference indexReference;

    private final ObjectReference targetReference;

    private AttachToIndexRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.indexReference = builder.indexReference;
        this.targetReference = builder.targetReference;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the directory where the object and index exist.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the directory where the object and index exist.
     */
    public String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * A reference to the index that you are attaching the object to.
     * </p>
     * 
     * @return A reference to the index that you are attaching the object to.
     */
    public ObjectReference indexReference() {
        return indexReference;
    }

    /**
     * <p>
     * A reference to the object that you are attaching to the index.
     * </p>
     * 
     * @return A reference to the object that you are attaching to the index.
     */
    public ObjectReference targetReference() {
        return targetReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(targetReference());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachToIndexRequest)) {
            return false;
        }
        AttachToIndexRequest other = (AttachToIndexRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(indexReference(), other.indexReference())
                && Objects.equals(targetReference(), other.targetReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttachToIndexRequest").add("DirectoryArn", directoryArn())
                .add("IndexReference", indexReference()).add("TargetReference", targetReference()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "IndexReference":
            return Optional.ofNullable(clazz.cast(indexReference()));
        case "TargetReference":
            return Optional.ofNullable(clazz.cast(targetReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachToIndexRequest, T> g) {
        return obj -> g.apply((AttachToIndexRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, AttachToIndexRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the directory where the object and index exist.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) of the directory where the object and index exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * A reference to the index that you are attaching the object to.
         * </p>
         * 
         * @param indexReference
         *        A reference to the index that you are attaching the object to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexReference(ObjectReference indexReference);

        /**
         * <p>
         * A reference to the index that you are attaching the object to.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #indexReference(ObjectReference)}.
         * 
         * @param indexReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexReference(ObjectReference)
         */
        default Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return indexReference(ObjectReference.builder().applyMutation(indexReference).build());
        }

        /**
         * <p>
         * A reference to the object that you are attaching to the index.
         * </p>
         * 
         * @param targetReference
         *        A reference to the object that you are attaching to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReference(ObjectReference targetReference);

        /**
         * <p>
         * A reference to the object that you are attaching to the index.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #targetReference(ObjectReference)}.
         * 
         * @param targetReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetReference(ObjectReference)
         */
        default Builder targetReference(Consumer<ObjectReference.Builder> targetReference) {
            return targetReference(ObjectReference.builder().applyMutation(targetReference).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private ObjectReference indexReference;

        private ObjectReference targetReference;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachToIndexRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            indexReference(model.indexReference);
            targetReference(model.targetReference);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getIndexReference() {
            return indexReference != null ? indexReference.toBuilder() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        public final ObjectReference.Builder getTargetReference() {
            return targetReference != null ? targetReference.toBuilder() : null;
        }

        @Override
        public final Builder targetReference(ObjectReference targetReference) {
            this.targetReference = targetReference;
            return this;
        }

        public final void setTargetReference(ObjectReference.BuilderImpl targetReference) {
            this.targetReference = targetReference != null ? targetReference.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachToIndexRequest build() {
            return new AttachToIndexRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
