/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ObjectType {
    NODE("NODE"),
    LEAF_NODE("LEAF_NODE"),
    POLICY("POLICY"),
    INDEX("INDEX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ObjectType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ObjectType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ObjectType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ObjectType> knownValues() {
        return Stream.of(ObjectType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

