/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse;

public class ListObjectParentPathsIterable
implements SdkIterable<ListObjectParentPathsResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectParentPathsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectParentPathsIterable(CloudDirectoryClient client, ListObjectParentPathsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectParentPathsResponseFetcher();
    }

    public Iterator<ListObjectParentPathsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListObjectParentPathsIterable resume(ListObjectParentPathsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListObjectParentPathsIterable(this.client, (ListObjectParentPathsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListObjectParentPathsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListObjectParentPathsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListObjectParentPathsResponseFetcher
    implements SyncPageFetcher<ListObjectParentPathsResponse> {
        private ListObjectParentPathsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectParentPathsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListObjectParentPathsResponse nextPage(ListObjectParentPathsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectParentPathsIterable.this.client.listObjectParentPaths(ListObjectParentPathsIterable.this.firstRequest);
            }
            return ListObjectParentPathsIterable.this.client.listObjectParentPaths((ListObjectParentPathsRequest)((Object)ListObjectParentPathsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

