/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.PolicyToPath;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PolicyToPathMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").isBinary(false).build();
    private static final MarshallingInfo<List> POLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policies").isBinary(false).build();
    private static final PolicyToPathMarshaller INSTANCE = new PolicyToPathMarshaller();

    private PolicyToPathMarshaller() {
    }

    public static PolicyToPathMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyToPath policyToPath, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)policyToPath, (String)"policyToPath");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)policyToPath.path(), PATH_BINDING);
            protocolMarshaller.marshall(policyToPath.policies(), POLICIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

