/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchWriteRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").isBinary(false).build();
    private static final MarshallingInfo<List> OPERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operations").isBinary(false).build();
    private static final BatchWriteRequestModelMarshaller INSTANCE = new BatchWriteRequestModelMarshaller();

    private BatchWriteRequestModelMarshaller() {
    }

    public static BatchWriteRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchWriteRequest batchWriteRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)batchWriteRequest), (String)"batchWriteRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchWriteRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall(batchWriteRequest.operations(), OPERATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

