/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;

public class ListObjectAttributesIterable
implements SdkIterable<ListObjectAttributesResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectAttributesIterable(CloudDirectoryClient client, ListObjectAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectAttributesResponseFetcher();
    }

    public Iterator<ListObjectAttributesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListObjectAttributesIterable resume(ListObjectAttributesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListObjectAttributesIterable(this.client, (ListObjectAttributesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListObjectAttributesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListObjectAttributesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListObjectAttributesResponseFetcher
    implements SyncPageFetcher<ListObjectAttributesResponse> {
        private ListObjectAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectAttributesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListObjectAttributesResponse nextPage(ListObjectAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectAttributesIterable.this.client.listObjectAttributes(ListObjectAttributesIterable.this.firstRequest);
            }
            return ListObjectAttributesIterable.this.client.listObjectAttributes((ListObjectAttributesRequest)((Object)ListObjectAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

