/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperationResponseListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchReadResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, BatchReadResponse> {
    private final List<BatchReadOperationResponse> responses;

    private BatchReadResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
    }

    public List<BatchReadOperationResponse> responses() {
        return this.responses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.responses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadResponse)) {
            return false;
        }
        BatchReadResponse other = (BatchReadResponse)((Object)obj);
        return Objects.equals(this.responses(), other.responses());
    }

    public String toString() {
        return ToString.builder((String)"BatchReadResponse").add("Responses", this.responses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Responses": {
                return Optional.of(clazz.cast(this.responses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<BatchReadOperationResponse> responses;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadResponse model) {
            this.responses(model.responses);
        }

        public final Collection<BatchReadOperationResponse.Builder> getResponses() {
            return this.responses != null ? (Collection)this.responses.stream().map(BatchReadOperationResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responses(Collection<BatchReadOperationResponse> responses) {
            this.responses = BatchReadOperationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(BatchReadOperationResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        public final void setResponses(Collection<BatchReadOperationResponse.BuilderImpl> responses) {
            this.responses = BatchReadOperationResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public BatchReadResponse build() {
            return new BatchReadResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, BatchReadResponse> {
        public Builder responses(Collection<BatchReadOperationResponse> var1);

        public Builder responses(BatchReadOperationResponse ... var1);
    }
}

