/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest;

@SdkInternalApi
public class CreateObjectRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").build();
    private static final MarshallingInfo<List> SCHEMAFACETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaFacets").build();
    private static final MarshallingInfo<List> OBJECTATTRIBUTELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectAttributeList").build();
    private static final MarshallingInfo<StructuredPojo> PARENTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentReference").build();
    private static final MarshallingInfo<String> LINKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LinkName").build();
    private static final CreateObjectRequestModelMarshaller INSTANCE = new CreateObjectRequestModelMarshaller();

    public static CreateObjectRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateObjectRequest createObjectRequest, ProtocolMarshaller protocolMarshaller) {
        if (createObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createObjectRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall(createObjectRequest.schemaFacets(), SCHEMAFACETS_BINDING);
            protocolMarshaller.marshall(createObjectRequest.objectAttributeList(), OBJECTATTRIBUTELIST_BINDING);
            protocolMarshaller.marshall((Object)createObjectRequest.parentReference(), PARENTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)createObjectRequest.linkName(), LINKNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

