/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadOperation;

@SdkInternalApi
public class BatchReadOperationMarshaller {
    private static final MarshallingInfo<StructuredPojo> LISTOBJECTATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListObjectAttributes").build();
    private static final MarshallingInfo<StructuredPojo> LISTOBJECTCHILDREN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListObjectChildren").build();
    private static final MarshallingInfo<StructuredPojo> LISTATTACHEDINDICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListAttachedIndices").build();
    private static final MarshallingInfo<StructuredPojo> LISTOBJECTPARENTPATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListObjectParentPaths").build();
    private static final MarshallingInfo<StructuredPojo> GETOBJECTINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GetObjectInformation").build();
    private static final MarshallingInfo<StructuredPojo> LISTOBJECTPOLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListObjectPolicies").build();
    private static final MarshallingInfo<StructuredPojo> LISTPOLICYATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListPolicyAttachments").build();
    private static final MarshallingInfo<StructuredPojo> LOOKUPPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LookupPolicy").build();
    private static final MarshallingInfo<StructuredPojo> LISTINDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListIndex").build();
    private static final MarshallingInfo<StructuredPojo> LISTOUTGOINGTYPEDLINKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListOutgoingTypedLinks").build();
    private static final MarshallingInfo<StructuredPojo> LISTINCOMINGTYPEDLINKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListIncomingTypedLinks").build();
    private static final BatchReadOperationMarshaller INSTANCE = new BatchReadOperationMarshaller();

    public static BatchReadOperationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchReadOperation batchReadOperation, ProtocolMarshaller protocolMarshaller) {
        if (batchReadOperation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)batchReadOperation.listObjectAttributes(), LISTOBJECTATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.listObjectChildren(), LISTOBJECTCHILDREN_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.listAttachedIndices(), LISTATTACHEDINDICES_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.listObjectParentPaths(), LISTOBJECTPARENTPATHS_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.getObjectInformation(), GETOBJECTINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.listObjectPolicies(), LISTOBJECTPOLICIES_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.listPolicyAttachments(), LISTPOLICYATTACHMENTS_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.lookupPolicy(), LOOKUPPOLICY_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.listIndex(), LISTINDEX_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.listOutgoingTypedLinks(), LISTOUTGOINGTYPEDLINKS_BINDING);
            protocolMarshaller.marshall((Object)batchReadOperation.listIncomingTypedLinks(), LISTINCOMINGTYPEDLINKS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

