/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchListIndex;
import software.amazon.awssdk.services.clouddirectory.transform.ObjectAttributeRangeUnmarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ObjectReferenceUnmarshaller;

public class BatchListIndexUnmarshaller
implements Unmarshaller<BatchListIndex, JsonUnmarshallerContext> {
    private static final BatchListIndexUnmarshaller INSTANCE = new BatchListIndexUnmarshaller();

    public BatchListIndex unmarshall(JsonUnmarshallerContext context) throws Exception {
        BatchListIndex.Builder batchListIndexBuilder = BatchListIndex.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RangesOnIndexedValues", targetDepth)) {
                    context.nextToken();
                    batchListIndexBuilder.rangesOnIndexedValues(new ListUnmarshaller((Unmarshaller)ObjectAttributeRangeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("IndexReference", targetDepth)) {
                    context.nextToken();
                    batchListIndexBuilder.indexReference(ObjectReferenceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MaxResults", targetDepth)) {
                    context.nextToken();
                    batchListIndexBuilder.maxResults((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("NextToken", targetDepth)) {
                    context.nextToken();
                    batchListIndexBuilder.nextToken((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BatchListIndex)batchListIndexBuilder.build();
    }

    public static BatchListIndexUnmarshaller getInstance() {
        return INSTANCE;
    }
}

