/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse;

public final class LookupPolicyPaginator
implements SdkIterable<LookupPolicyResponse> {
    private final CloudDirectoryClient client;
    private final LookupPolicyRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public LookupPolicyPaginator(CloudDirectoryClient client, LookupPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new LookupPolicyResponseFetcher();
    }

    public Iterator<LookupPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class LookupPolicyResponseFetcher
    implements NextPageFetcher<LookupPolicyResponse> {
        private LookupPolicyResponseFetcher() {
        }

        public boolean hasNextPage(LookupPolicyResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public LookupPolicyResponse nextPage(LookupPolicyResponse previousPage) {
            if (previousPage == null) {
                return LookupPolicyPaginator.this.client.lookupPolicy(LookupPolicyPaginator.this.firstRequest);
            }
            return LookupPolicyPaginator.this.client.lookupPolicy((LookupPolicyRequest)((Object)LookupPolicyPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

