/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;

public final class ListTypedLinkFacetNamesPaginator
implements SdkIterable<ListTypedLinkFacetNamesResponse> {
    private final CloudDirectoryClient client;
    private final ListTypedLinkFacetNamesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTypedLinkFacetNamesPaginator(CloudDirectoryClient client, ListTypedLinkFacetNamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTypedLinkFacetNamesResponseFetcher();
    }

    public Iterator<ListTypedLinkFacetNamesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListTypedLinkFacetNamesResponseFetcher
    implements NextPageFetcher<ListTypedLinkFacetNamesResponse> {
        private ListTypedLinkFacetNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypedLinkFacetNamesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTypedLinkFacetNamesResponse nextPage(ListTypedLinkFacetNamesResponse previousPage) {
            if (previousPage == null) {
                return ListTypedLinkFacetNamesPaginator.this.client.listTypedLinkFacetNames(ListTypedLinkFacetNamesPaginator.this.firstRequest);
            }
            return ListTypedLinkFacetNamesPaginator.this.client.listTypedLinkFacetNames((ListTypedLinkFacetNamesRequest)((Object)ListTypedLinkFacetNamesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

