/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse;

public final class ListPublishedSchemaArnsPaginator
implements SdkIterable<ListPublishedSchemaArnsResponse> {
    private final CloudDirectoryClient client;
    private final ListPublishedSchemaArnsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPublishedSchemaArnsPaginator(CloudDirectoryClient client, ListPublishedSchemaArnsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPublishedSchemaArnsResponseFetcher();
    }

    public Iterator<ListPublishedSchemaArnsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListPublishedSchemaArnsResponseFetcher
    implements NextPageFetcher<ListPublishedSchemaArnsResponse> {
        private ListPublishedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListPublishedSchemaArnsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListPublishedSchemaArnsResponse nextPage(ListPublishedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListPublishedSchemaArnsPaginator.this.client.listPublishedSchemaArns(ListPublishedSchemaArnsPaginator.this.firstRequest);
            }
            return ListPublishedSchemaArnsPaginator.this.client.listPublishedSchemaArns((ListPublishedSchemaArnsRequest)((Object)ListPublishedSchemaArnsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

