/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse;

public final class ListObjectParentsPaginator
implements SdkIterable<ListObjectParentsResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectParentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListObjectParentsPaginator(CloudDirectoryClient client, ListObjectParentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectParentsResponseFetcher();
    }

    public Iterator<ListObjectParentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListObjectParentsResponseFetcher
    implements NextPageFetcher<ListObjectParentsResponse> {
        private ListObjectParentsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectParentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListObjectParentsResponse nextPage(ListObjectParentsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectParentsPaginator.this.client.listObjectParents(ListObjectParentsPaginator.this.firstRequest);
            }
            return ListObjectParentsPaginator.this.client.listObjectParents((ListObjectParentsRequest)((Object)ListObjectParentsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

