/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse;

public final class ListObjectChildrenPaginator
implements SdkIterable<ListObjectChildrenResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectChildrenRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListObjectChildrenPaginator(CloudDirectoryClient client, ListObjectChildrenRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectChildrenResponseFetcher();
    }

    public Iterator<ListObjectChildrenResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListObjectChildrenResponseFetcher
    implements NextPageFetcher<ListObjectChildrenResponse> {
        private ListObjectChildrenResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectChildrenResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListObjectChildrenResponse nextPage(ListObjectChildrenResponse previousPage) {
            if (previousPage == null) {
                return ListObjectChildrenPaginator.this.client.listObjectChildren(ListObjectChildrenPaginator.this.firstRequest);
            }
            return ListObjectChildrenPaginator.this.client.listObjectChildren((ListObjectChildrenRequest)((Object)ListObjectChildrenPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

