/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse;

public final class ListFacetAttributesPaginator
implements SdkIterable<ListFacetAttributesResponse> {
    private final CloudDirectoryClient client;
    private final ListFacetAttributesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListFacetAttributesPaginator(CloudDirectoryClient client, ListFacetAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFacetAttributesResponseFetcher();
    }

    public Iterator<ListFacetAttributesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListFacetAttributesResponseFetcher
    implements NextPageFetcher<ListFacetAttributesResponse> {
        private ListFacetAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacetAttributesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListFacetAttributesResponse nextPage(ListFacetAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListFacetAttributesPaginator.this.client.listFacetAttributes(ListFacetAttributesPaginator.this.firstRequest);
            }
            return ListFacetAttributesPaginator.this.client.listFacetAttributes((ListFacetAttributesRequest)((Object)ListFacetAttributesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

