/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse;

public final class ListAppliedSchemaArnsPaginator
implements SdkIterable<ListAppliedSchemaArnsResponse> {
    private final CloudDirectoryClient client;
    private final ListAppliedSchemaArnsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAppliedSchemaArnsPaginator(CloudDirectoryClient client, ListAppliedSchemaArnsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppliedSchemaArnsResponseFetcher();
    }

    public Iterator<ListAppliedSchemaArnsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListAppliedSchemaArnsResponseFetcher
    implements NextPageFetcher<ListAppliedSchemaArnsResponse> {
        private ListAppliedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppliedSchemaArnsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListAppliedSchemaArnsResponse nextPage(ListAppliedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListAppliedSchemaArnsPaginator.this.client.listAppliedSchemaArns(ListAppliedSchemaArnsPaginator.this.firstRequest);
            }
            return ListAppliedSchemaArnsPaginator.this.client.listAppliedSchemaArns((ListAppliedSchemaArnsRequest)((Object)ListAppliedSchemaArnsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

