/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeUpdateListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateFacetRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, UpdateFacetRequest> {
    private final String schemaArn;
    private final String name;
    private final List<FacetAttributeUpdate> attributeUpdates;
    private final String objectType;

    private UpdateFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributeUpdates = builder.attributeUpdates;
        this.objectType = builder.objectType;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String name() {
        return this.name;
    }

    public List<FacetAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public ObjectType objectType() {
        return ObjectType.fromValue(this.objectType);
    }

    public String objectTypeString() {
        return this.objectType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFacetRequest)) {
            return false;
        }
        UpdateFacetRequest other = (UpdateFacetRequest)((Object)obj);
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.attributeUpdates(), other.attributeUpdates()) && Objects.equals(this.objectTypeString(), other.objectTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.schemaArn() != null) {
            sb.append("SchemaArn: ").append(this.schemaArn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.attributeUpdates() != null) {
            sb.append("AttributeUpdates: ").append(this.attributeUpdates()).append(",");
        }
        if (this.objectTypeString() != null) {
            sb.append("ObjectType: ").append(this.objectTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.of(clazz.cast(this.schemaArn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "AttributeUpdates": {
                return Optional.of(clazz.cast(this.attributeUpdates()));
            }
            case "ObjectType": {
                return Optional.of(clazz.cast(this.objectTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String schemaArn;
        private String name;
        private List<FacetAttributeUpdate> attributeUpdates;
        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFacetRequest model) {
            this.schemaArn(model.schemaArn);
            this.name(model.name);
            this.attributeUpdates(model.attributeUpdates);
            this.objectType(model.objectType);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<FacetAttributeUpdate.Builder> getAttributeUpdates() {
            return this.attributeUpdates != null ? (Collection)this.attributeUpdates.stream().map(FacetAttributeUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeUpdates(Collection<FacetAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = FacetAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(FacetAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        public final void setAttributeUpdates(Collection<FacetAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = FacetAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        public final String getObjectType() {
            return this.objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateFacetRequest build() {
            return new UpdateFacetRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, UpdateFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder name(String var1);

        public Builder attributeUpdates(Collection<FacetAttributeUpdate> var1);

        public Builder attributeUpdates(FacetAttributeUpdate ... var1);

        public Builder objectType(String var1);

        public Builder objectType(ObjectType var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

