/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.FacetNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFacetNamesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListFacetNamesResponse> {
    private final List<String> facetNames;
    private final String nextToken;

    private ListFacetNamesResponse(BuilderImpl builder) {
        super(builder);
        this.facetNames = builder.facetNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> facetNames() {
        return this.facetNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.facetNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacetNamesResponse)) {
            return false;
        }
        ListFacetNamesResponse other = (ListFacetNamesResponse)((Object)obj);
        return Objects.equals(this.facetNames(), other.facetNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.facetNames() != null) {
            sb.append("FacetNames: ").append(this.facetNames()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FacetNames": {
                return Optional.of(clazz.cast(this.facetNames()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<String> facetNames;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacetNamesResponse model) {
            this.facetNames(model.facetNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getFacetNames() {
            return this.facetNames;
        }

        @Override
        public final Builder facetNames(Collection<String> facetNames) {
            this.facetNames = FacetNameListCopier.copy(facetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetNames(String ... facetNames) {
            this.facetNames(Arrays.asList(facetNames));
            return this;
        }

        public final void setFacetNames(Collection<String> facetNames) {
            this.facetNames = FacetNameListCopier.copy(facetNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFacetNamesResponse build() {
            return new ListFacetNamesResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListFacetNamesResponse> {
        public Builder facetNames(Collection<String> var1);

        public Builder facetNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

