/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeReference;
import software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior;
import software.amazon.awssdk.services.clouddirectory.transform.FacetAttributeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FacetAttribute
implements StructuredPojo,
ToCopyableBuilder<Builder, FacetAttribute> {
    private final String name;
    private final FacetAttributeDefinition attributeDefinition;
    private final FacetAttributeReference attributeReference;
    private final String requiredBehavior;

    private FacetAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.attributeDefinition = builder.attributeDefinition;
        this.attributeReference = builder.attributeReference;
        this.requiredBehavior = builder.requiredBehavior;
    }

    public String name() {
        return this.name;
    }

    public FacetAttributeDefinition attributeDefinition() {
        return this.attributeDefinition;
    }

    public FacetAttributeReference attributeReference() {
        return this.attributeReference;
    }

    public RequiredAttributeBehavior requiredBehavior() {
        return RequiredAttributeBehavior.fromValue(this.requiredBehavior);
    }

    public String requiredBehaviorString() {
        return this.requiredBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredBehaviorString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttribute)) {
            return false;
        }
        FacetAttribute other = (FacetAttribute)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.attributeDefinition(), other.attributeDefinition()) && Objects.equals(this.attributeReference(), other.attributeReference()) && Objects.equals(this.requiredBehaviorString(), other.requiredBehaviorString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.attributeDefinition() != null) {
            sb.append("AttributeDefinition: ").append(this.attributeDefinition()).append(",");
        }
        if (this.attributeReference() != null) {
            sb.append("AttributeReference: ").append(this.attributeReference()).append(",");
        }
        if (this.requiredBehaviorString() != null) {
            sb.append("RequiredBehavior: ").append(this.requiredBehaviorString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "AttributeDefinition": {
                return Optional.of(clazz.cast(this.attributeDefinition()));
            }
            case "AttributeReference": {
                return Optional.of(clazz.cast(this.attributeReference()));
            }
            case "RequiredBehavior": {
                return Optional.of(clazz.cast(this.requiredBehaviorString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FacetAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private FacetAttributeDefinition attributeDefinition;
        private FacetAttributeReference attributeReference;
        private String requiredBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttribute model) {
            this.name(model.name);
            this.attributeDefinition(model.attributeDefinition);
            this.attributeReference(model.attributeReference);
            this.requiredBehavior(model.requiredBehavior);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final FacetAttributeDefinition.Builder getAttributeDefinition() {
            return this.attributeDefinition != null ? this.attributeDefinition.toBuilder() : null;
        }

        @Override
        public final Builder attributeDefinition(FacetAttributeDefinition attributeDefinition) {
            this.attributeDefinition = attributeDefinition;
            return this;
        }

        public final void setAttributeDefinition(FacetAttributeDefinition.BuilderImpl attributeDefinition) {
            this.attributeDefinition = attributeDefinition != null ? attributeDefinition.build() : null;
        }

        public final FacetAttributeReference.Builder getAttributeReference() {
            return this.attributeReference != null ? this.attributeReference.toBuilder() : null;
        }

        @Override
        public final Builder attributeReference(FacetAttributeReference attributeReference) {
            this.attributeReference = attributeReference;
            return this;
        }

        public final void setAttributeReference(FacetAttributeReference.BuilderImpl attributeReference) {
            this.attributeReference = attributeReference != null ? attributeReference.build() : null;
        }

        public final String getRequiredBehavior() {
            return this.requiredBehavior;
        }

        @Override
        public final Builder requiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
            return this;
        }

        @Override
        public final Builder requiredBehavior(RequiredAttributeBehavior requiredBehavior) {
            this.requiredBehavior(requiredBehavior.toString());
            return this;
        }

        public final void setRequiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
        }

        public FacetAttribute build() {
            return new FacetAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FacetAttribute> {
        public Builder name(String var1);

        public Builder attributeDefinition(FacetAttributeDefinition var1);

        default public Builder attributeDefinition(Consumer<FacetAttributeDefinition.Builder> attributeDefinition) {
            return this.attributeDefinition((FacetAttributeDefinition)((FacetAttributeDefinition.Builder)FacetAttributeDefinition.builder().apply(attributeDefinition)).build());
        }

        public Builder attributeReference(FacetAttributeReference var1);

        default public Builder attributeReference(Consumer<FacetAttributeReference.Builder> attributeReference) {
            return this.attributeReference((FacetAttributeReference)((FacetAttributeReference.Builder)FacetAttributeReference.builder().apply(attributeReference)).build());
        }

        public Builder requiredBehavior(String var1);

        public Builder requiredBehavior(RequiredAttributeBehavior var1);
    }
}

