/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.transform.BatchListObjectAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchListObjectAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchListObjectAttributes> {
    private final ObjectReference objectReference;
    private final String nextToken;
    private final Integer maxResults;
    private final SchemaFacet facetFilter;

    private BatchListObjectAttributes(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.facetFilter = builder.facetFilter;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public SchemaFacet facetFilter() {
        return this.facetFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetFilter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectAttributes)) {
            return false;
        }
        BatchListObjectAttributes other = (BatchListObjectAttributes)obj;
        return Objects.equals(this.objectReference(), other.objectReference()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.facetFilter(), other.facetFilter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.objectReference() != null) {
            sb.append("ObjectReference: ").append(this.objectReference()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.facetFilter() != null) {
            sb.append("FacetFilter: ").append(this.facetFilter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectReference": {
                return Optional.of(clazz.cast(this.objectReference()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "FacetFilter": {
                return Optional.of(clazz.cast(this.facetFilter()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchListObjectAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference objectReference;
        private String nextToken;
        private Integer maxResults;
        private SchemaFacet facetFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectAttributes model) {
            this.objectReference(model.objectReference);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.facetFilter(model.facetFilter);
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final SchemaFacet.Builder getFacetFilter() {
            return this.facetFilter != null ? this.facetFilter.toBuilder() : null;
        }

        @Override
        public final Builder facetFilter(SchemaFacet facetFilter) {
            this.facetFilter = facetFilter;
            return this;
        }

        public final void setFacetFilter(SchemaFacet.BuilderImpl facetFilter) {
            this.facetFilter = facetFilter != null ? facetFilter.build() : null;
        }

        public BatchListObjectAttributes build() {
            return new BatchListObjectAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchListObjectAttributes> {
        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(objectReference)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder facetFilter(SchemaFacet var1);

        default public Builder facetFilter(Consumer<SchemaFacet.Builder> facetFilter) {
            return this.facetFilter((SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().apply(facetFilter)).build());
        }
    }
}

