/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchCreateIndexMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchCreateIndex
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchCreateIndex> {
    private final List<AttributeKey> orderedIndexedAttributeList;
    private final Boolean isUnique;
    private final ObjectReference parentReference;
    private final String linkName;
    private final String batchReferenceName;

    private BatchCreateIndex(BuilderImpl builder) {
        this.orderedIndexedAttributeList = builder.orderedIndexedAttributeList;
        this.isUnique = builder.isUnique;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    public List<AttributeKey> orderedIndexedAttributeList() {
        return this.orderedIndexedAttributeList;
    }

    public Boolean isUnique() {
        return this.isUnique;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public String batchReferenceName() {
        return this.batchReferenceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orderedIndexedAttributeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.isUnique());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchReferenceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateIndex)) {
            return false;
        }
        BatchCreateIndex other = (BatchCreateIndex)obj;
        return Objects.equals(this.orderedIndexedAttributeList(), other.orderedIndexedAttributeList()) && Objects.equals(this.isUnique(), other.isUnique()) && Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.linkName(), other.linkName()) && Objects.equals(this.batchReferenceName(), other.batchReferenceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.orderedIndexedAttributeList() != null) {
            sb.append("OrderedIndexedAttributeList: ").append(this.orderedIndexedAttributeList()).append(",");
        }
        if (this.isUnique() != null) {
            sb.append("IsUnique: ").append(this.isUnique()).append(",");
        }
        if (this.parentReference() != null) {
            sb.append("ParentReference: ").append(this.parentReference()).append(",");
        }
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        if (this.batchReferenceName() != null) {
            sb.append("BatchReferenceName: ").append(this.batchReferenceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderedIndexedAttributeList": {
                return Optional.of(clazz.cast(this.orderedIndexedAttributeList()));
            }
            case "IsUnique": {
                return Optional.of(clazz.cast(this.isUnique()));
            }
            case "ParentReference": {
                return Optional.of(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.of(clazz.cast(this.linkName()));
            }
            case "BatchReferenceName": {
                return Optional.of(clazz.cast(this.batchReferenceName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchCreateIndexMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeKey> orderedIndexedAttributeList;
        private Boolean isUnique;
        private ObjectReference parentReference;
        private String linkName;
        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateIndex model) {
            this.orderedIndexedAttributeList(model.orderedIndexedAttributeList);
            this.isUnique(model.isUnique);
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
            this.batchReferenceName(model.batchReferenceName);
        }

        public final Collection<AttributeKey.Builder> getOrderedIndexedAttributeList() {
            return this.orderedIndexedAttributeList != null ? (Collection)this.orderedIndexedAttributeList.stream().map(AttributeKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copy(orderedIndexedAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(AttributeKey ... orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList(Arrays.asList(orderedIndexedAttributeList));
            return this;
        }

        public final void setOrderedIndexedAttributeList(Collection<AttributeKey.BuilderImpl> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copyFromBuilder(orderedIndexedAttributeList);
        }

        public final Boolean getIsUnique() {
            return this.isUnique;
        }

        @Override
        public final Builder isUnique(Boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public final void setIsUnique(Boolean isUnique) {
            this.isUnique = isUnique;
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public final String getBatchReferenceName() {
            return this.batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        public BatchCreateIndex build() {
            return new BatchCreateIndex(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchCreateIndex> {
        public Builder orderedIndexedAttributeList(Collection<AttributeKey> var1);

        public Builder orderedIndexedAttributeList(AttributeKey ... var1);

        public Builder isUnique(Boolean var1);

        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(parentReference)).build());
        }

        public Builder linkName(String var1);

        public Builder batchReferenceName(String var1);
    }
}

