/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.services.clouddirectory.transform.BatchAttachTypedLinkMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchAttachTypedLink
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchAttachTypedLink> {
    private final ObjectReference sourceObjectReference;
    private final ObjectReference targetObjectReference;
    private final TypedLinkSchemaAndFacetName typedLinkFacet;
    private final List<AttributeNameAndValue> attributes;

    private BatchAttachTypedLink(BuilderImpl builder) {
        this.sourceObjectReference = builder.sourceObjectReference;
        this.targetObjectReference = builder.targetObjectReference;
        this.typedLinkFacet = builder.typedLinkFacet;
        this.attributes = builder.attributes;
    }

    public ObjectReference sourceObjectReference() {
        return this.sourceObjectReference;
    }

    public ObjectReference targetObjectReference() {
        return this.targetObjectReference;
    }

    public TypedLinkSchemaAndFacetName typedLinkFacet() {
        return this.typedLinkFacet;
    }

    public List<AttributeNameAndValue> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachTypedLink)) {
            return false;
        }
        BatchAttachTypedLink other = (BatchAttachTypedLink)obj;
        return Objects.equals(this.sourceObjectReference(), other.sourceObjectReference()) && Objects.equals(this.targetObjectReference(), other.targetObjectReference()) && Objects.equals(this.typedLinkFacet(), other.typedLinkFacet()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceObjectReference() != null) {
            sb.append("SourceObjectReference: ").append(this.sourceObjectReference()).append(",");
        }
        if (this.targetObjectReference() != null) {
            sb.append("TargetObjectReference: ").append(this.targetObjectReference()).append(",");
        }
        if (this.typedLinkFacet() != null) {
            sb.append("TypedLinkFacet: ").append(this.typedLinkFacet()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceObjectReference": {
                return Optional.of(clazz.cast(this.sourceObjectReference()));
            }
            case "TargetObjectReference": {
                return Optional.of(clazz.cast(this.targetObjectReference()));
            }
            case "TypedLinkFacet": {
                return Optional.of(clazz.cast(this.typedLinkFacet()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchAttachTypedLinkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference sourceObjectReference;
        private ObjectReference targetObjectReference;
        private TypedLinkSchemaAndFacetName typedLinkFacet;
        private List<AttributeNameAndValue> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachTypedLink model) {
            this.sourceObjectReference(model.sourceObjectReference);
            this.targetObjectReference(model.targetObjectReference);
            this.typedLinkFacet(model.typedLinkFacet);
            this.attributes(model.attributes);
        }

        public final ObjectReference.Builder getSourceObjectReference() {
            return this.sourceObjectReference != null ? this.sourceObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder sourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
            return this;
        }

        public final void setSourceObjectReference(ObjectReference.BuilderImpl sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference != null ? sourceObjectReference.build() : null;
        }

        public final ObjectReference.Builder getTargetObjectReference() {
            return this.targetObjectReference != null ? this.targetObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder targetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
            return this;
        }

        public final void setTargetObjectReference(ObjectReference.BuilderImpl targetObjectReference) {
            this.targetObjectReference = targetObjectReference != null ? targetObjectReference.build() : null;
        }

        public final TypedLinkSchemaAndFacetName.Builder getTypedLinkFacet() {
            return this.typedLinkFacet != null ? this.typedLinkFacet.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
            return this;
        }

        public final void setTypedLinkFacet(TypedLinkSchemaAndFacetName.BuilderImpl typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet != null ? typedLinkFacet.build() : null;
        }

        public final Collection<AttributeNameAndValue.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeNameAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeNameAndValue> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeNameAndValue ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<AttributeNameAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copyFromBuilder(attributes);
        }

        public BatchAttachTypedLink build() {
            return new BatchAttachTypedLink(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchAttachTypedLink> {
        public Builder sourceObjectReference(ObjectReference var1);

        default public Builder sourceObjectReference(Consumer<ObjectReference.Builder> sourceObjectReference) {
            return this.sourceObjectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(sourceObjectReference)).build());
        }

        public Builder targetObjectReference(ObjectReference var1);

        default public Builder targetObjectReference(Consumer<ObjectReference.Builder> targetObjectReference) {
            return this.targetObjectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(targetObjectReference)).build());
        }

        public Builder typedLinkFacet(TypedLinkSchemaAndFacetName var1);

        default public Builder typedLinkFacet(Consumer<TypedLinkSchemaAndFacetName.Builder> typedLinkFacet) {
            return this.typedLinkFacet((TypedLinkSchemaAndFacetName)((TypedLinkSchemaAndFacetName.Builder)TypedLinkSchemaAndFacetName.builder().apply(typedLinkFacet)).build());
        }

        public Builder attributes(Collection<AttributeNameAndValue> var1);

        public Builder attributes(AttributeNameAndValue ... var1);
    }
}

