/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplySchemaRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, ApplySchemaRequest> {
    private final String publishedSchemaArn;
    private final String directoryArn;

    private ApplySchemaRequest(BuilderImpl builder) {
        super(builder);
        this.publishedSchemaArn = builder.publishedSchemaArn;
        this.directoryArn = builder.directoryArn;
    }

    public String publishedSchemaArn() {
        return this.publishedSchemaArn;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.publishedSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySchemaRequest)) {
            return false;
        }
        ApplySchemaRequest other = (ApplySchemaRequest)((Object)obj);
        return Objects.equals(this.publishedSchemaArn(), other.publishedSchemaArn()) && Objects.equals(this.directoryArn(), other.directoryArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.publishedSchemaArn() != null) {
            sb.append("PublishedSchemaArn: ").append(this.publishedSchemaArn()).append(",");
        }
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublishedSchemaArn": {
                return Optional.of(clazz.cast(this.publishedSchemaArn()));
            }
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String publishedSchemaArn;
        private String directoryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplySchemaRequest model) {
            this.publishedSchemaArn(model.publishedSchemaArn);
            this.directoryArn(model.directoryArn);
        }

        public final String getPublishedSchemaArn() {
            return this.publishedSchemaArn;
        }

        @Override
        public final Builder publishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
            return this;
        }

        public final void setPublishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ApplySchemaRequest build() {
            return new ApplySchemaRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, ApplySchemaRequest> {
        public Builder publishedSchemaArn(String var1);

        public Builder directoryArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

