/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.nio.ByteBuffer;
import java.time.Instant;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;

@SdkInternalApi
public class TypedAttributeValueMarshaller {
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringValue").build();
    private static final MarshallingInfo<ByteBuffer> BINARYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BinaryValue").build();
    private static final MarshallingInfo<Boolean> BOOLEANVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BooleanValue").build();
    private static final MarshallingInfo<String> NUMBERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberValue").build();
    private static final MarshallingInfo<Instant> DATETIMEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatetimeValue").build();
    private static final TypedAttributeValueMarshaller INSTANCE = new TypedAttributeValueMarshaller();

    public static TypedAttributeValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TypedAttributeValue typedAttributeValue, ProtocolMarshaller protocolMarshaller) {
        if (typedAttributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)typedAttributeValue.stringValue(), STRINGVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValue.binaryValue(), BINARYVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValue.booleanValue(), BOOLEANVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValue.numberValue(), NUMBERVALUE_BINDING);
            protocolMarshaller.marshall((Object)typedAttributeValue.datetimeValue(), DATETIMEVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

