/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment;
import software.amazon.awssdk.services.clouddirectory.model.PolicyAttachmentListCopier;
import software.amazon.awssdk.services.clouddirectory.transform.PolicyToPathMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PolicyToPath
implements StructuredPojo,
ToCopyableBuilder<Builder, PolicyToPath> {
    private final String path;
    private final List<PolicyAttachment> policies;

    private PolicyToPath(BuilderImpl builder) {
        this.path = builder.path;
        this.policies = builder.policies;
    }

    public String path() {
        return this.path;
    }

    public List<PolicyAttachment> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.policies() == null ? 0 : this.policies().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyToPath)) {
            return false;
        }
        PolicyToPath other = (PolicyToPath)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.policies() == null ^ this.policies() == null) {
            return false;
        }
        return other.policies() == null || other.policies().equals(this.policies());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.policies() != null) {
            sb.append("Policies: ").append(this.policies()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PolicyToPathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private List<PolicyAttachment> policies;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyToPath model) {
            this.setPath(model.path);
            this.setPolicies(model.policies);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<PolicyAttachment> getPolicies() {
            return this.policies;
        }

        @Override
        public final Builder policies(Collection<PolicyAttachment> policies) {
            this.policies = PolicyAttachmentListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyAttachment ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        public final void setPolicies(Collection<PolicyAttachment> policies) {
            this.policies = PolicyAttachmentListCopier.copy(policies);
        }

        public PolicyToPath build() {
            return new PolicyToPath(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PolicyToPath> {
        public Builder path(String var1);

        public Builder policies(Collection<PolicyAttachment> var1);

        public Builder policies(PolicyAttachment ... var1);
    }
}

