/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes;
import software.amazon.awssdk.services.clouddirectory.transform.BatchWriteOperationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteOperation
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchWriteOperation> {
    private final BatchCreateObject createObject;
    private final BatchAttachObject attachObject;
    private final BatchDetachObject detachObject;
    private final BatchUpdateObjectAttributes updateObjectAttributes;
    private final BatchDeleteObject deleteObject;
    private final BatchAddFacetToObject addFacetToObject;
    private final BatchRemoveFacetFromObject removeFacetFromObject;

    private BatchWriteOperation(BuilderImpl builder) {
        this.createObject = builder.createObject;
        this.attachObject = builder.attachObject;
        this.detachObject = builder.detachObject;
        this.updateObjectAttributes = builder.updateObjectAttributes;
        this.deleteObject = builder.deleteObject;
        this.addFacetToObject = builder.addFacetToObject;
        this.removeFacetFromObject = builder.removeFacetFromObject;
    }

    public BatchCreateObject createObject() {
        return this.createObject;
    }

    public BatchAttachObject attachObject() {
        return this.attachObject;
    }

    public BatchDetachObject detachObject() {
        return this.detachObject;
    }

    public BatchUpdateObjectAttributes updateObjectAttributes() {
        return this.updateObjectAttributes;
    }

    public BatchDeleteObject deleteObject() {
        return this.deleteObject;
    }

    public BatchAddFacetToObject addFacetToObject() {
        return this.addFacetToObject;
    }

    public BatchRemoveFacetFromObject removeFacetFromObject() {
        return this.removeFacetFromObject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createObject() == null ? 0 : this.createObject().hashCode());
        hashCode = 31 * hashCode + (this.attachObject() == null ? 0 : this.attachObject().hashCode());
        hashCode = 31 * hashCode + (this.detachObject() == null ? 0 : this.detachObject().hashCode());
        hashCode = 31 * hashCode + (this.updateObjectAttributes() == null ? 0 : this.updateObjectAttributes().hashCode());
        hashCode = 31 * hashCode + (this.deleteObject() == null ? 0 : this.deleteObject().hashCode());
        hashCode = 31 * hashCode + (this.addFacetToObject() == null ? 0 : this.addFacetToObject().hashCode());
        hashCode = 31 * hashCode + (this.removeFacetFromObject() == null ? 0 : this.removeFacetFromObject().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteOperation)) {
            return false;
        }
        BatchWriteOperation other = (BatchWriteOperation)obj;
        if (other.createObject() == null ^ this.createObject() == null) {
            return false;
        }
        if (other.createObject() != null && !other.createObject().equals(this.createObject())) {
            return false;
        }
        if (other.attachObject() == null ^ this.attachObject() == null) {
            return false;
        }
        if (other.attachObject() != null && !other.attachObject().equals(this.attachObject())) {
            return false;
        }
        if (other.detachObject() == null ^ this.detachObject() == null) {
            return false;
        }
        if (other.detachObject() != null && !other.detachObject().equals(this.detachObject())) {
            return false;
        }
        if (other.updateObjectAttributes() == null ^ this.updateObjectAttributes() == null) {
            return false;
        }
        if (other.updateObjectAttributes() != null && !other.updateObjectAttributes().equals(this.updateObjectAttributes())) {
            return false;
        }
        if (other.deleteObject() == null ^ this.deleteObject() == null) {
            return false;
        }
        if (other.deleteObject() != null && !other.deleteObject().equals(this.deleteObject())) {
            return false;
        }
        if (other.addFacetToObject() == null ^ this.addFacetToObject() == null) {
            return false;
        }
        if (other.addFacetToObject() != null && !other.addFacetToObject().equals(this.addFacetToObject())) {
            return false;
        }
        if (other.removeFacetFromObject() == null ^ this.removeFacetFromObject() == null) {
            return false;
        }
        return other.removeFacetFromObject() == null || other.removeFacetFromObject().equals(this.removeFacetFromObject());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createObject() != null) {
            sb.append("CreateObject: ").append(this.createObject()).append(",");
        }
        if (this.attachObject() != null) {
            sb.append("AttachObject: ").append(this.attachObject()).append(",");
        }
        if (this.detachObject() != null) {
            sb.append("DetachObject: ").append(this.detachObject()).append(",");
        }
        if (this.updateObjectAttributes() != null) {
            sb.append("UpdateObjectAttributes: ").append(this.updateObjectAttributes()).append(",");
        }
        if (this.deleteObject() != null) {
            sb.append("DeleteObject: ").append(this.deleteObject()).append(",");
        }
        if (this.addFacetToObject() != null) {
            sb.append("AddFacetToObject: ").append(this.addFacetToObject()).append(",");
        }
        if (this.removeFacetFromObject() != null) {
            sb.append("RemoveFacetFromObject: ").append(this.removeFacetFromObject()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchWriteOperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private BatchCreateObject createObject;
        private BatchAttachObject attachObject;
        private BatchDetachObject detachObject;
        private BatchUpdateObjectAttributes updateObjectAttributes;
        private BatchDeleteObject deleteObject;
        private BatchAddFacetToObject addFacetToObject;
        private BatchRemoveFacetFromObject removeFacetFromObject;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteOperation model) {
            this.setCreateObject(model.createObject);
            this.setAttachObject(model.attachObject);
            this.setDetachObject(model.detachObject);
            this.setUpdateObjectAttributes(model.updateObjectAttributes);
            this.setDeleteObject(model.deleteObject);
            this.setAddFacetToObject(model.addFacetToObject);
            this.setRemoveFacetFromObject(model.removeFacetFromObject);
        }

        public final BatchCreateObject getCreateObject() {
            return this.createObject;
        }

        @Override
        public final Builder createObject(BatchCreateObject createObject) {
            this.createObject = createObject;
            return this;
        }

        public final void setCreateObject(BatchCreateObject createObject) {
            this.createObject = createObject;
        }

        public final BatchAttachObject getAttachObject() {
            return this.attachObject;
        }

        @Override
        public final Builder attachObject(BatchAttachObject attachObject) {
            this.attachObject = attachObject;
            return this;
        }

        public final void setAttachObject(BatchAttachObject attachObject) {
            this.attachObject = attachObject;
        }

        public final BatchDetachObject getDetachObject() {
            return this.detachObject;
        }

        @Override
        public final Builder detachObject(BatchDetachObject detachObject) {
            this.detachObject = detachObject;
            return this;
        }

        public final void setDetachObject(BatchDetachObject detachObject) {
            this.detachObject = detachObject;
        }

        public final BatchUpdateObjectAttributes getUpdateObjectAttributes() {
            return this.updateObjectAttributes;
        }

        @Override
        public final Builder updateObjectAttributes(BatchUpdateObjectAttributes updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
            return this;
        }

        public final void setUpdateObjectAttributes(BatchUpdateObjectAttributes updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
        }

        public final BatchDeleteObject getDeleteObject() {
            return this.deleteObject;
        }

        @Override
        public final Builder deleteObject(BatchDeleteObject deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public final void setDeleteObject(BatchDeleteObject deleteObject) {
            this.deleteObject = deleteObject;
        }

        public final BatchAddFacetToObject getAddFacetToObject() {
            return this.addFacetToObject;
        }

        @Override
        public final Builder addFacetToObject(BatchAddFacetToObject addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
            return this;
        }

        public final void setAddFacetToObject(BatchAddFacetToObject addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
        }

        public final BatchRemoveFacetFromObject getRemoveFacetFromObject() {
            return this.removeFacetFromObject;
        }

        @Override
        public final Builder removeFacetFromObject(BatchRemoveFacetFromObject removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
            return this;
        }

        public final void setRemoveFacetFromObject(BatchRemoveFacetFromObject removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
        }

        public BatchWriteOperation build() {
            return new BatchWriteOperation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteOperation> {
        public Builder createObject(BatchCreateObject var1);

        public Builder attachObject(BatchAttachObject var1);

        public Builder detachObject(BatchDetachObject var1);

        public Builder updateObjectAttributes(BatchUpdateObjectAttributes var1);

        public Builder deleteObject(BatchDeleteObject var1);

        public Builder addFacetToObject(BatchAddFacetToObject var1);

        public Builder removeFacetFromObject(BatchRemoveFacetFromObject var1);
    }
}

