/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.services.clouddirectory.transform.TypedLinkSpecifierMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TypedLinkSpecifier
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedLinkSpecifier> {
    private final TypedLinkSchemaAndFacetName typedLinkFacet;
    private final ObjectReference sourceObjectReference;
    private final ObjectReference targetObjectReference;
    private final List<AttributeNameAndValue> identityAttributeValues;

    private TypedLinkSpecifier(BuilderImpl builder) {
        this.typedLinkFacet = builder.typedLinkFacet;
        this.sourceObjectReference = builder.sourceObjectReference;
        this.targetObjectReference = builder.targetObjectReference;
        this.identityAttributeValues = builder.identityAttributeValues;
    }

    public TypedLinkSchemaAndFacetName typedLinkFacet() {
        return this.typedLinkFacet;
    }

    public ObjectReference sourceObjectReference() {
        return this.sourceObjectReference;
    }

    public ObjectReference targetObjectReference() {
        return this.targetObjectReference;
    }

    public List<AttributeNameAndValue> identityAttributeValues() {
        return this.identityAttributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.typedLinkFacet() == null ? 0 : this.typedLinkFacet().hashCode());
        hashCode = 31 * hashCode + (this.sourceObjectReference() == null ? 0 : this.sourceObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.targetObjectReference() == null ? 0 : this.targetObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.identityAttributeValues() == null ? 0 : this.identityAttributeValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkSpecifier)) {
            return false;
        }
        TypedLinkSpecifier other = (TypedLinkSpecifier)obj;
        if (other.typedLinkFacet() == null ^ this.typedLinkFacet() == null) {
            return false;
        }
        if (other.typedLinkFacet() != null && !other.typedLinkFacet().equals(this.typedLinkFacet())) {
            return false;
        }
        if (other.sourceObjectReference() == null ^ this.sourceObjectReference() == null) {
            return false;
        }
        if (other.sourceObjectReference() != null && !other.sourceObjectReference().equals(this.sourceObjectReference())) {
            return false;
        }
        if (other.targetObjectReference() == null ^ this.targetObjectReference() == null) {
            return false;
        }
        if (other.targetObjectReference() != null && !other.targetObjectReference().equals(this.targetObjectReference())) {
            return false;
        }
        if (other.identityAttributeValues() == null ^ this.identityAttributeValues() == null) {
            return false;
        }
        return other.identityAttributeValues() == null || other.identityAttributeValues().equals(this.identityAttributeValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.typedLinkFacet() != null) {
            sb.append("TypedLinkFacet: ").append(this.typedLinkFacet()).append(",");
        }
        if (this.sourceObjectReference() != null) {
            sb.append("SourceObjectReference: ").append(this.sourceObjectReference()).append(",");
        }
        if (this.targetObjectReference() != null) {
            sb.append("TargetObjectReference: ").append(this.targetObjectReference()).append(",");
        }
        if (this.identityAttributeValues() != null) {
            sb.append("IdentityAttributeValues: ").append(this.identityAttributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkSpecifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private TypedLinkSchemaAndFacetName typedLinkFacet;
        private ObjectReference sourceObjectReference;
        private ObjectReference targetObjectReference;
        private List<AttributeNameAndValue> identityAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkSpecifier model) {
            this.setTypedLinkFacet(model.typedLinkFacet);
            this.setSourceObjectReference(model.sourceObjectReference);
            this.setTargetObjectReference(model.targetObjectReference);
            this.setIdentityAttributeValues(model.identityAttributeValues);
        }

        public final TypedLinkSchemaAndFacetName getTypedLinkFacet() {
            return this.typedLinkFacet;
        }

        @Override
        public final Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
            return this;
        }

        public final void setTypedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
        }

        public final ObjectReference getSourceObjectReference() {
            return this.sourceObjectReference;
        }

        @Override
        public final Builder sourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
            return this;
        }

        public final void setSourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
        }

        public final ObjectReference getTargetObjectReference() {
            return this.targetObjectReference;
        }

        @Override
        public final Builder targetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
            return this;
        }

        public final void setTargetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
        }

        public final Collection<AttributeNameAndValue> getIdentityAttributeValues() {
            return this.identityAttributeValues;
        }

        @Override
        public final Builder identityAttributeValues(Collection<AttributeNameAndValue> identityAttributeValues) {
            this.identityAttributeValues = AttributeNameAndValueListCopier.copy(identityAttributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeValues(AttributeNameAndValue ... identityAttributeValues) {
            this.identityAttributeValues(Arrays.asList(identityAttributeValues));
            return this;
        }

        public final void setIdentityAttributeValues(Collection<AttributeNameAndValue> identityAttributeValues) {
            this.identityAttributeValues = AttributeNameAndValueListCopier.copy(identityAttributeValues);
        }

        public TypedLinkSpecifier build() {
            return new TypedLinkSpecifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedLinkSpecifier> {
        public Builder typedLinkFacet(TypedLinkSchemaAndFacetName var1);

        public Builder sourceObjectReference(ObjectReference var1);

        public Builder targetObjectReference(ObjectReference var1);

        public Builder identityAttributeValues(Collection<AttributeNameAndValue> var1);

        public Builder identityAttributeValues(AttributeNameAndValue ... var1);
    }
}

