/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.transform.FacetAttributeReferenceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FacetAttributeReference
implements StructuredPojo,
ToCopyableBuilder<Builder, FacetAttributeReference> {
    private final String targetFacetName;
    private final String targetAttributeName;

    private FacetAttributeReference(BuilderImpl builder) {
        this.targetFacetName = builder.targetFacetName;
        this.targetAttributeName = builder.targetAttributeName;
    }

    public String targetFacetName() {
        return this.targetFacetName;
    }

    public String targetAttributeName() {
        return this.targetAttributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetFacetName() == null ? 0 : this.targetFacetName().hashCode());
        hashCode = 31 * hashCode + (this.targetAttributeName() == null ? 0 : this.targetAttributeName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttributeReference)) {
            return false;
        }
        FacetAttributeReference other = (FacetAttributeReference)obj;
        if (other.targetFacetName() == null ^ this.targetFacetName() == null) {
            return false;
        }
        if (other.targetFacetName() != null && !other.targetFacetName().equals(this.targetFacetName())) {
            return false;
        }
        if (other.targetAttributeName() == null ^ this.targetAttributeName() == null) {
            return false;
        }
        return other.targetAttributeName() == null || other.targetAttributeName().equals(this.targetAttributeName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetFacetName() != null) {
            sb.append("TargetFacetName: ").append(this.targetFacetName()).append(",");
        }
        if (this.targetAttributeName() != null) {
            sb.append("TargetAttributeName: ").append(this.targetAttributeName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FacetAttributeReferenceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String targetFacetName;
        private String targetAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttributeReference model) {
            this.setTargetFacetName(model.targetFacetName);
            this.setTargetAttributeName(model.targetAttributeName);
        }

        public final String getTargetFacetName() {
            return this.targetFacetName;
        }

        @Override
        public final Builder targetFacetName(String targetFacetName) {
            this.targetFacetName = targetFacetName;
            return this;
        }

        public final void setTargetFacetName(String targetFacetName) {
            this.targetFacetName = targetFacetName;
        }

        public final String getTargetAttributeName() {
            return this.targetAttributeName;
        }

        @Override
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        public FacetAttributeReference build() {
            return new FacetAttributeReference(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FacetAttributeReference> {
        public Builder targetFacetName(String var1);

        public Builder targetAttributeName(String var1);
    }
}

