/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperationResponseListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchWriteResponse> {
    private final List<BatchWriteOperationResponse> responses;

    private BatchWriteResponse(BuilderImpl builder) {
        this.responses = builder.responses;
    }

    public List<BatchWriteOperationResponse> responses() {
        return this.responses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.responses() == null ? 0 : this.responses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteResponse)) {
            return false;
        }
        BatchWriteResponse other = (BatchWriteResponse)((Object)obj);
        if (other.responses() == null ^ this.responses() == null) {
            return false;
        }
        return other.responses() == null || other.responses().equals(this.responses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.responses() != null) {
            sb.append("Responses: ").append(this.responses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<BatchWriteOperationResponse> responses;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteResponse model) {
            this.setResponses(model.responses);
        }

        public final Collection<BatchWriteOperationResponse> getResponses() {
            return this.responses;
        }

        @Override
        public final Builder responses(Collection<BatchWriteOperationResponse> responses) {
            this.responses = BatchWriteOperationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(BatchWriteOperationResponse ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        public final void setResponses(Collection<BatchWriteOperationResponse> responses) {
            this.responses = BatchWriteOperationResponseListCopier.copy(responses);
        }

        public BatchWriteResponse build() {
            return new BatchWriteResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteResponse> {
        public Builder responses(Collection<BatchWriteOperationResponse> var1);

        public Builder responses(BatchWriteOperationResponse ... var1);
    }
}

