/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchAttachObjectMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchAttachObject
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchAttachObject> {
    private final ObjectReference parentReference;
    private final ObjectReference childReference;
    private final String linkName;

    private BatchAttachObject(BuilderImpl builder) {
        this.parentReference = builder.parentReference;
        this.childReference = builder.childReference;
        this.linkName = builder.linkName;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public ObjectReference childReference() {
        return this.childReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parentReference() == null ? 0 : this.parentReference().hashCode());
        hashCode = 31 * hashCode + (this.childReference() == null ? 0 : this.childReference().hashCode());
        hashCode = 31 * hashCode + (this.linkName() == null ? 0 : this.linkName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachObject)) {
            return false;
        }
        BatchAttachObject other = (BatchAttachObject)obj;
        if (other.parentReference() == null ^ this.parentReference() == null) {
            return false;
        }
        if (other.parentReference() != null && !other.parentReference().equals(this.parentReference())) {
            return false;
        }
        if (other.childReference() == null ^ this.childReference() == null) {
            return false;
        }
        if (other.childReference() != null && !other.childReference().equals(this.childReference())) {
            return false;
        }
        if (other.linkName() == null ^ this.linkName() == null) {
            return false;
        }
        return other.linkName() == null || other.linkName().equals(this.linkName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parentReference() != null) {
            sb.append("ParentReference: ").append(this.parentReference()).append(",");
        }
        if (this.childReference() != null) {
            sb.append("ChildReference: ").append(this.childReference()).append(",");
        }
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchAttachObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ObjectReference parentReference;
        private ObjectReference childReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachObject model) {
            this.setParentReference(model.parentReference);
            this.setChildReference(model.childReference);
            this.setLinkName(model.linkName);
        }

        public final ObjectReference getParentReference() {
            return this.parentReference;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
        }

        public final ObjectReference getChildReference() {
            return this.childReference;
        }

        @Override
        public final Builder childReference(ObjectReference childReference) {
            this.childReference = childReference;
            return this;
        }

        public final void setChildReference(ObjectReference childReference) {
            this.childReference = childReference;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public BatchAttachObject build() {
            return new BatchAttachObject(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchAttachObject> {
        public Builder parentReference(ObjectReference var1);

        public Builder childReference(ObjectReference var1);

        public Builder linkName(String var1);
    }
}

