/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIncomingTypedLinksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListIncomingTypedLinksResponse> {
    private final List<TypedLinkSpecifier> linkSpecifiers;
    private final String nextToken;

    private ListIncomingTypedLinksResponse(BuilderImpl builder) {
        this.linkSpecifiers = builder.linkSpecifiers;
        this.nextToken = builder.nextToken;
    }

    public List<TypedLinkSpecifier> linkSpecifiers() {
        return this.linkSpecifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.linkSpecifiers() == null ? 0 : this.linkSpecifiers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIncomingTypedLinksResponse)) {
            return false;
        }
        ListIncomingTypedLinksResponse other = (ListIncomingTypedLinksResponse)((Object)obj);
        if (other.linkSpecifiers() == null ^ this.linkSpecifiers() == null) {
            return false;
        }
        if (other.linkSpecifiers() != null && !other.linkSpecifiers().equals(this.linkSpecifiers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.linkSpecifiers() != null) {
            sb.append("LinkSpecifiers: ").append(this.linkSpecifiers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TypedLinkSpecifier> linkSpecifiers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIncomingTypedLinksResponse model) {
            this.setLinkSpecifiers(model.linkSpecifiers);
            this.setNextToken(model.nextToken);
        }

        public final Collection<TypedLinkSpecifier> getLinkSpecifiers() {
            return this.linkSpecifiers;
        }

        @Override
        public final Builder linkSpecifiers(Collection<TypedLinkSpecifier> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copy(linkSpecifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkSpecifiers(TypedLinkSpecifier ... linkSpecifiers) {
            this.linkSpecifiers(Arrays.asList(linkSpecifiers));
            return this;
        }

        public final void setLinkSpecifiers(Collection<TypedLinkSpecifier> linkSpecifiers) {
            this.linkSpecifiers = TypedLinkSpecifierListCopier.copy(linkSpecifiers);
        }

        @SafeVarargs
        public final void setLinkSpecifiers(TypedLinkSpecifier ... linkSpecifiers) {
            this.linkSpecifiers(Arrays.asList(linkSpecifiers));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListIncomingTypedLinksResponse build() {
            return new ListIncomingTypedLinksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListIncomingTypedLinksResponse> {
        public Builder linkSpecifiers(Collection<TypedLinkSpecifier> var1);

        public Builder linkSpecifiers(TypedLinkSpecifier ... var1);

        public Builder nextToken(String var1);
    }
}

