/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.clouddirectory.model.FacetNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListFacetNamesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListFacetNamesResponse> {
    private final List<String> facetNames;
    private final String nextToken;

    private ListFacetNamesResponse(BuilderImpl builder) {
        this.facetNames = builder.facetNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> facetNames() {
        return this.facetNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.facetNames() == null ? 0 : this.facetNames().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacetNamesResponse)) {
            return false;
        }
        ListFacetNamesResponse other = (ListFacetNamesResponse)((Object)obj);
        if (other.facetNames() == null ^ this.facetNames() == null) {
            return false;
        }
        if (other.facetNames() != null && !other.facetNames().equals(this.facetNames())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.facetNames() != null) {
            sb.append("FacetNames: ").append(this.facetNames()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> facetNames;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacetNamesResponse model) {
            this.setFacetNames(model.facetNames);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getFacetNames() {
            return this.facetNames;
        }

        @Override
        public final Builder facetNames(Collection<String> facetNames) {
            this.facetNames = FacetNameListCopier.copy(facetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetNames(String ... facetNames) {
            this.facetNames(Arrays.asList(facetNames));
            return this;
        }

        public final void setFacetNames(Collection<String> facetNames) {
            this.facetNames = FacetNameListCopier.copy(facetNames);
        }

        @SafeVarargs
        public final void setFacetNames(String ... facetNames) {
            this.facetNames(Arrays.asList(facetNames));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListFacetNamesResponse build() {
            return new ListFacetNamesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListFacetNamesResponse> {
        public Builder facetNames(Collection<String> var1);

        public Builder facetNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

