/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeUpdateListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.transform.BatchUpdateObjectAttributesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchUpdateObjectAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchUpdateObjectAttributes> {
    private final ObjectReference objectReference;
    private final List<ObjectAttributeUpdate> attributeUpdates;

    private BatchUpdateObjectAttributes(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.attributeUpdates = builder.attributeUpdates;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public List<ObjectAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.objectReference() == null ? 0 : this.objectReference().hashCode());
        hashCode = 31 * hashCode + (this.attributeUpdates() == null ? 0 : this.attributeUpdates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateObjectAttributes)) {
            return false;
        }
        BatchUpdateObjectAttributes other = (BatchUpdateObjectAttributes)obj;
        if (other.objectReference() == null ^ this.objectReference() == null) {
            return false;
        }
        if (other.objectReference() != null && !other.objectReference().equals(this.objectReference())) {
            return false;
        }
        if (other.attributeUpdates() == null ^ this.attributeUpdates() == null) {
            return false;
        }
        return other.attributeUpdates() == null || other.attributeUpdates().equals(this.attributeUpdates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.objectReference() != null) {
            sb.append("ObjectReference: ").append(this.objectReference()).append(",");
        }
        if (this.attributeUpdates() != null) {
            sb.append("AttributeUpdates: ").append(this.attributeUpdates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchUpdateObjectAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ObjectReference objectReference;
        private List<ObjectAttributeUpdate> attributeUpdates;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateObjectAttributes model) {
            this.setObjectReference(model.objectReference);
            this.setAttributeUpdates(model.attributeUpdates);
        }

        public final ObjectReference getObjectReference() {
            return this.objectReference;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
        }

        public final Collection<ObjectAttributeUpdate> getAttributeUpdates() {
            return this.attributeUpdates;
        }

        @Override
        public final Builder attributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(ObjectAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        public final void setAttributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = ObjectAttributeUpdateListCopier.copy(attributeUpdates);
        }

        @SafeVarargs
        public final void setAttributeUpdates(ObjectAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
        }

        public BatchUpdateObjectAttributes build() {
            return new BatchUpdateObjectAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchUpdateObjectAttributes> {
        public Builder objectReference(ObjectReference var1);

        public Builder attributeUpdates(Collection<ObjectAttributeUpdate> var1);

        public Builder attributeUpdates(ObjectAttributeUpdate ... var1);
    }
}

