/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter criteria to use in determining the requests returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceRequestStatusFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceRequestStatusFilter.Builder, ResourceRequestStatusFilter> {
    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Operations")
            .getter(getter(ResourceRequestStatusFilter::operationsAsStrings))
            .setter(setter(Builder::operationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPERATION_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OperationStatuses")
            .getter(getter(ResourceRequestStatusFilter::operationStatusesAsStrings))
            .setter(setter(Builder::operationStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONS_FIELD,
            OPERATION_STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> operations;

    private final List<String> operationStatuses;

    private ResourceRequestStatusFilter(BuilderImpl builder) {
        this.operations = builder.operations;
        this.operationStatuses = builder.operationStatuses;
    }

    /**
     * <p>
     * The operation types to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperations} method.
     * </p>
     * 
     * @return The operation types to include in the filter.
     */
    public final List<Operation> operations() {
        return OperationsCopier.copyStringToEnum(operations);
    }

    /**
     * For responses, this returns true if the service returned a value for the Operations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOperations() {
        return operations != null && !(operations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operation types to include in the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperations} method.
     * </p>
     * 
     * @return The operation types to include in the filter.
     */
    public final List<String> operationsAsStrings() {
        return operations;
    }

    /**
     * <p>
     * The operation statuses to include in the filter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The operation has been requested, but not yet initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: The operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code>: The operation completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCEL_COMPLETE</code>: The operation has been canceled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperationStatuses} method.
     * </p>
     * 
     * @return The operation statuses to include in the filter.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The operation has been requested, but not yet initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: The operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code>: The operation completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCEL_COMPLETE</code>: The operation has been canceled.
     *         </p>
     *         </li>
     */
    public final List<OperationStatus> operationStatuses() {
        return OperationStatusesCopier.copyStringToEnum(operationStatuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the OperationStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperationStatuses() {
        return operationStatuses != null && !(operationStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operation statuses to include in the filter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The operation has been requested, but not yet initiated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: The operation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code>: The operation completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The operation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCEL_COMPLETE</code>: The operation has been canceled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperationStatuses} method.
     * </p>
     * 
     * @return The operation statuses to include in the filter.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The operation has been requested, but not yet initiated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: The operation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code>: The operation completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The operation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCEL_COMPLETE</code>: The operation has been canceled.
     *         </p>
     *         </li>
     */
    public final List<String> operationStatusesAsStrings() {
        return operationStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOperations() ? operationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOperationStatuses() ? operationStatusesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRequestStatusFilter)) {
            return false;
        }
        ResourceRequestStatusFilter other = (ResourceRequestStatusFilter) obj;
        return hasOperations() == other.hasOperations() && Objects.equals(operationsAsStrings(), other.operationsAsStrings())
                && hasOperationStatuses() == other.hasOperationStatuses()
                && Objects.equals(operationStatusesAsStrings(), other.operationStatusesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceRequestStatusFilter").add("Operations", hasOperations() ? operationsAsStrings() : null)
                .add("OperationStatuses", hasOperationStatuses() ? operationStatusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operations":
            return Optional.ofNullable(clazz.cast(operationsAsStrings()));
        case "OperationStatuses":
            return Optional.ofNullable(clazz.cast(operationStatusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Operations", OPERATIONS_FIELD);
        map.put("OperationStatuses", OPERATION_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceRequestStatusFilter, T> g) {
        return obj -> g.apply((ResourceRequestStatusFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceRequestStatusFilter> {
        /**
         * <p>
         * The operation types to include in the filter.
         * </p>
         * 
         * @param operations
         *        The operation types to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationsWithStrings(Collection<String> operations);

        /**
         * <p>
         * The operation types to include in the filter.
         * </p>
         * 
         * @param operations
         *        The operation types to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationsWithStrings(String... operations);

        /**
         * <p>
         * The operation types to include in the filter.
         * </p>
         * 
         * @param operations
         *        The operation types to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * The operation types to include in the filter.
         * </p>
         * 
         * @param operations
         *        The operation types to include in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);

        /**
         * <p>
         * The operation statuses to include in the filter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation has been requested, but not yet initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code>: The operation completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_COMPLETE</code>: The operation has been canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationStatuses
         *        The operation statuses to include in the filter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The operation has been requested, but not yet initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code>: The operation completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_COMPLETE</code>: The operation has been canceled.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationStatusesWithStrings(Collection<String> operationStatuses);

        /**
         * <p>
         * The operation statuses to include in the filter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation has been requested, but not yet initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code>: The operation completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_COMPLETE</code>: The operation has been canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationStatuses
         *        The operation statuses to include in the filter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The operation has been requested, but not yet initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code>: The operation completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_COMPLETE</code>: The operation has been canceled.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationStatusesWithStrings(String... operationStatuses);

        /**
         * <p>
         * The operation statuses to include in the filter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation has been requested, but not yet initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code>: The operation completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_COMPLETE</code>: The operation has been canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationStatuses
         *        The operation statuses to include in the filter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The operation has been requested, but not yet initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code>: The operation completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_COMPLETE</code>: The operation has been canceled.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationStatuses(Collection<OperationStatus> operationStatuses);

        /**
         * <p>
         * The operation statuses to include in the filter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The operation has been requested, but not yet initiated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The operation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code>: The operation completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The operation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCEL_COMPLETE</code>: The operation has been canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param operationStatuses
         *        The operation statuses to include in the filter.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The operation has been requested, but not yet initiated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The operation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code>: The operation completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The operation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_IN_PROGRESS</code>: The operation is in the process of being canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCEL_COMPLETE</code>: The operation has been canceled.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationStatuses(OperationStatus... operationStatuses);
    }

    static final class BuilderImpl implements Builder {
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();

        private List<String> operationStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceRequestStatusFilter model) {
            operationsWithStrings(model.operations);
            operationStatusesWithStrings(model.operationStatuses);
        }

        public final Collection<String> getOperations() {
            if (operations instanceof SdkAutoConstructList) {
                return null;
            }
            return operations;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = OperationsCopier.copy(operations);
        }

        @Override
        public final Builder operationsWithStrings(Collection<String> operations) {
            this.operations = OperationsCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationsWithStrings(String... operations) {
            operationsWithStrings(Arrays.asList(operations));
            return this;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationsCopier.copyEnumToString(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final Collection<String> getOperationStatuses() {
            if (operationStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return operationStatuses;
        }

        public final void setOperationStatuses(Collection<String> operationStatuses) {
            this.operationStatuses = OperationStatusesCopier.copy(operationStatuses);
        }

        @Override
        public final Builder operationStatusesWithStrings(Collection<String> operationStatuses) {
            this.operationStatuses = OperationStatusesCopier.copy(operationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationStatusesWithStrings(String... operationStatuses) {
            operationStatusesWithStrings(Arrays.asList(operationStatuses));
            return this;
        }

        @Override
        public final Builder operationStatuses(Collection<OperationStatus> operationStatuses) {
            this.operationStatuses = OperationStatusesCopier.copyEnumToString(operationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationStatuses(OperationStatus... operationStatuses) {
            operationStatuses(Arrays.asList(operationStatuses));
            return this;
        }

        @Override
        public ResourceRequestStatusFilter build() {
            return new ResourceRequestStatusFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
