/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the current status of applicable Hooks for a resource operation request. It contains list of Hook
 * invocation information for the resource specified in the request since the same target can invoke multiple Hooks. For
 * more information, see <a
 * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations-manage-requests.html">Managing
 * resource operation requests with Amazon Web Services Cloud Control API </a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HookProgressEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<HookProgressEvent.Builder, HookProgressEvent> {
    private static final SdkField<String> HOOK_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookTypeName").getter(getter(HookProgressEvent::hookTypeName)).setter(setter(Builder::hookTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookTypeName").build()).build();

    private static final SdkField<String> HOOK_TYPE_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookTypeVersionId").getter(getter(HookProgressEvent::hookTypeVersionId))
            .setter(setter(Builder::hookTypeVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookTypeVersionId").build()).build();

    private static final SdkField<String> HOOK_TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookTypeArn").getter(getter(HookProgressEvent::hookTypeArn)).setter(setter(Builder::hookTypeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookTypeArn").build()).build();

    private static final SdkField<String> INVOCATION_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationPoint").getter(getter(HookProgressEvent::invocationPoint))
            .setter(setter(Builder::invocationPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPoint").build()).build();

    private static final SdkField<String> HOOK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatus").getter(getter(HookProgressEvent::hookStatus)).setter(setter(Builder::hookStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatus").build()).build();

    private static final SdkField<Instant> HOOK_EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("HookEventTime").getter(getter(HookProgressEvent::hookEventTime)).setter(setter(Builder::hookEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookEventTime").build()).build();

    private static final SdkField<String> HOOK_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatusMessage").getter(getter(HookProgressEvent::hookStatusMessage))
            .setter(setter(Builder::hookStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusMessage").build()).build();

    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMode").getter(getter(HookProgressEvent::failureMode)).setter(setter(Builder::failureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOOK_TYPE_NAME_FIELD,
            HOOK_TYPE_VERSION_ID_FIELD, HOOK_TYPE_ARN_FIELD, INVOCATION_POINT_FIELD, HOOK_STATUS_FIELD, HOOK_EVENT_TIME_FIELD,
            HOOK_STATUS_MESSAGE_FIELD, FAILURE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hookTypeName;

    private final String hookTypeVersionId;

    private final String hookTypeArn;

    private final String invocationPoint;

    private final String hookStatus;

    private final Instant hookEventTime;

    private final String hookStatusMessage;

    private final String failureMode;

    private HookProgressEvent(BuilderImpl builder) {
        this.hookTypeName = builder.hookTypeName;
        this.hookTypeVersionId = builder.hookTypeVersionId;
        this.hookTypeArn = builder.hookTypeArn;
        this.invocationPoint = builder.invocationPoint;
        this.hookStatus = builder.hookStatus;
        this.hookEventTime = builder.hookEventTime;
        this.hookStatusMessage = builder.hookStatusMessage;
        this.failureMode = builder.failureMode;
    }

    /**
     * <p>
     * The type name of the Hook being invoked.
     * </p>
     * 
     * @return The type name of the Hook being invoked.
     */
    public final String hookTypeName() {
        return hookTypeName;
    }

    /**
     * <p>
     * The type version of the Hook being invoked.
     * </p>
     * 
     * @return The type version of the Hook being invoked.
     */
    public final String hookTypeVersionId() {
        return hookTypeVersionId;
    }

    /**
     * <p>
     * The ARN of the Hook being invoked.
     * </p>
     * 
     * @return The ARN of the Hook being invoked.
     */
    public final String hookTypeArn() {
        return hookTypeArn;
    }

    /**
     * <p>
     * States whether the Hook is invoked before or after resource provisioning.
     * </p>
     * 
     * @return States whether the Hook is invoked before or after resource provisioning.
     */
    public final String invocationPoint() {
        return invocationPoint;
    }

    /**
     * <p>
     * The status of the Hook invocation. The following are potential statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOOK_PENDING</code>: The Hook was added to the invocation plan, but not yet invoked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_IN_PROGRESS</code>: The Hook was invoked, but hasn't completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook invocation is complete with a successful result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_FAILED</code>: The Hook invocation is complete with a failed result.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_FAILED</code>: The Hook invocation didn't complete successfully.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the Hook invocation. The following are potential statuses:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOOK_PENDING</code>: The Hook was added to the invocation plan, but not yet invoked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_IN_PROGRESS</code>: The Hook was invoked, but hasn't completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook invocation is complete with a successful result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_FAILED</code>: The Hook invocation is complete with a failed result.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_FAILED</code>: The Hook invocation didn't complete successfully.
     *         </p>
     *         </li>
     */
    public final String hookStatus() {
        return hookStatus;
    }

    /**
     * <p>
     * The time that the Hook invocation request initiated.
     * </p>
     * 
     * @return The time that the Hook invocation request initiated.
     */
    public final Instant hookEventTime() {
        return hookEventTime;
    }

    /**
     * <p>
     * The message explaining the current Hook status.
     * </p>
     * 
     * @return The message explaining the current Hook status.
     */
    public final String hookStatusMessage() {
        return hookStatusMessage;
    }

    /**
     * <p>
     * The failure mode of the invocation. The following are the potential statuses:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAIL</code>: This will fail the Hook invocation and the request associated with it.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN</code>: This will fail the Hook invocation, but not the request associated with it.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The failure mode of the invocation. The following are the potential statuses:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAIL</code>: This will fail the Hook invocation and the request associated with it.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN</code>: This will fail the Hook invocation, but not the request associated with it.
     *         </p>
     *         </li>
     */
    public final String failureMode() {
        return failureMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hookTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hookTypeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(hookTypeArn());
        hashCode = 31 * hashCode + Objects.hashCode(invocationPoint());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hookEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(failureMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HookProgressEvent)) {
            return false;
        }
        HookProgressEvent other = (HookProgressEvent) obj;
        return Objects.equals(hookTypeName(), other.hookTypeName())
                && Objects.equals(hookTypeVersionId(), other.hookTypeVersionId())
                && Objects.equals(hookTypeArn(), other.hookTypeArn())
                && Objects.equals(invocationPoint(), other.invocationPoint()) && Objects.equals(hookStatus(), other.hookStatus())
                && Objects.equals(hookEventTime(), other.hookEventTime())
                && Objects.equals(hookStatusMessage(), other.hookStatusMessage())
                && Objects.equals(failureMode(), other.failureMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HookProgressEvent").add("HookTypeName", hookTypeName())
                .add("HookTypeVersionId", hookTypeVersionId()).add("HookTypeArn", hookTypeArn())
                .add("InvocationPoint", invocationPoint()).add("HookStatus", hookStatus()).add("HookEventTime", hookEventTime())
                .add("HookStatusMessage", hookStatusMessage()).add("FailureMode", failureMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HookTypeName":
            return Optional.ofNullable(clazz.cast(hookTypeName()));
        case "HookTypeVersionId":
            return Optional.ofNullable(clazz.cast(hookTypeVersionId()));
        case "HookTypeArn":
            return Optional.ofNullable(clazz.cast(hookTypeArn()));
        case "InvocationPoint":
            return Optional.ofNullable(clazz.cast(invocationPoint()));
        case "HookStatus":
            return Optional.ofNullable(clazz.cast(hookStatus()));
        case "HookEventTime":
            return Optional.ofNullable(clazz.cast(hookEventTime()));
        case "HookStatusMessage":
            return Optional.ofNullable(clazz.cast(hookStatusMessage()));
        case "FailureMode":
            return Optional.ofNullable(clazz.cast(failureMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HookTypeName", HOOK_TYPE_NAME_FIELD);
        map.put("HookTypeVersionId", HOOK_TYPE_VERSION_ID_FIELD);
        map.put("HookTypeArn", HOOK_TYPE_ARN_FIELD);
        map.put("InvocationPoint", INVOCATION_POINT_FIELD);
        map.put("HookStatus", HOOK_STATUS_FIELD);
        map.put("HookEventTime", HOOK_EVENT_TIME_FIELD);
        map.put("HookStatusMessage", HOOK_STATUS_MESSAGE_FIELD);
        map.put("FailureMode", FAILURE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HookProgressEvent, T> g) {
        return obj -> g.apply((HookProgressEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HookProgressEvent> {
        /**
         * <p>
         * The type name of the Hook being invoked.
         * </p>
         * 
         * @param hookTypeName
         *        The type name of the Hook being invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookTypeName(String hookTypeName);

        /**
         * <p>
         * The type version of the Hook being invoked.
         * </p>
         * 
         * @param hookTypeVersionId
         *        The type version of the Hook being invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookTypeVersionId(String hookTypeVersionId);

        /**
         * <p>
         * The ARN of the Hook being invoked.
         * </p>
         * 
         * @param hookTypeArn
         *        The ARN of the Hook being invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookTypeArn(String hookTypeArn);

        /**
         * <p>
         * States whether the Hook is invoked before or after resource provisioning.
         * </p>
         * 
         * @param invocationPoint
         *        States whether the Hook is invoked before or after resource provisioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationPoint(String invocationPoint);

        /**
         * <p>
         * The status of the Hook invocation. The following are potential statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOOK_PENDING</code>: The Hook was added to the invocation plan, but not yet invoked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_IN_PROGRESS</code>: The Hook was invoked, but hasn't completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook invocation is complete with a successful result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_FAILED</code>: The Hook invocation is complete with a failed result.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_FAILED</code>: The Hook invocation didn't complete successfully.
         * </p>
         * </li>
         * </ul>
         * 
         * @param hookStatus
         *        The status of the Hook invocation. The following are potential statuses:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOOK_PENDING</code>: The Hook was added to the invocation plan, but not yet invoked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_IN_PROGRESS</code>: The Hook was invoked, but hasn't completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook invocation is complete with a successful result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_FAILED</code>: The Hook invocation is complete with a failed result.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_FAILED</code>: The Hook invocation didn't complete successfully.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookStatus(String hookStatus);

        /**
         * <p>
         * The time that the Hook invocation request initiated.
         * </p>
         * 
         * @param hookEventTime
         *        The time that the Hook invocation request initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookEventTime(Instant hookEventTime);

        /**
         * <p>
         * The message explaining the current Hook status.
         * </p>
         * 
         * @param hookStatusMessage
         *        The message explaining the current Hook status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookStatusMessage(String hookStatusMessage);

        /**
         * <p>
         * The failure mode of the invocation. The following are the potential statuses:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAIL</code>: This will fail the Hook invocation and the request associated with it.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN</code>: This will fail the Hook invocation, but not the request associated with it.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureMode
         *        The failure mode of the invocation. The following are the potential statuses:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAIL</code>: This will fail the Hook invocation and the request associated with it.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN</code>: This will fail the Hook invocation, but not the request associated with it.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMode(String failureMode);
    }

    static final class BuilderImpl implements Builder {
        private String hookTypeName;

        private String hookTypeVersionId;

        private String hookTypeArn;

        private String invocationPoint;

        private String hookStatus;

        private Instant hookEventTime;

        private String hookStatusMessage;

        private String failureMode;

        private BuilderImpl() {
        }

        private BuilderImpl(HookProgressEvent model) {
            hookTypeName(model.hookTypeName);
            hookTypeVersionId(model.hookTypeVersionId);
            hookTypeArn(model.hookTypeArn);
            invocationPoint(model.invocationPoint);
            hookStatus(model.hookStatus);
            hookEventTime(model.hookEventTime);
            hookStatusMessage(model.hookStatusMessage);
            failureMode(model.failureMode);
        }

        public final String getHookTypeName() {
            return hookTypeName;
        }

        public final void setHookTypeName(String hookTypeName) {
            this.hookTypeName = hookTypeName;
        }

        @Override
        public final Builder hookTypeName(String hookTypeName) {
            this.hookTypeName = hookTypeName;
            return this;
        }

        public final String getHookTypeVersionId() {
            return hookTypeVersionId;
        }

        public final void setHookTypeVersionId(String hookTypeVersionId) {
            this.hookTypeVersionId = hookTypeVersionId;
        }

        @Override
        public final Builder hookTypeVersionId(String hookTypeVersionId) {
            this.hookTypeVersionId = hookTypeVersionId;
            return this;
        }

        public final String getHookTypeArn() {
            return hookTypeArn;
        }

        public final void setHookTypeArn(String hookTypeArn) {
            this.hookTypeArn = hookTypeArn;
        }

        @Override
        public final Builder hookTypeArn(String hookTypeArn) {
            this.hookTypeArn = hookTypeArn;
            return this;
        }

        public final String getInvocationPoint() {
            return invocationPoint;
        }

        public final void setInvocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
        }

        @Override
        public final Builder invocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
            return this;
        }

        public final String getHookStatus() {
            return hookStatus;
        }

        public final void setHookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
        }

        @Override
        public final Builder hookStatus(String hookStatus) {
            this.hookStatus = hookStatus;
            return this;
        }

        public final Instant getHookEventTime() {
            return hookEventTime;
        }

        public final void setHookEventTime(Instant hookEventTime) {
            this.hookEventTime = hookEventTime;
        }

        @Override
        public final Builder hookEventTime(Instant hookEventTime) {
            this.hookEventTime = hookEventTime;
            return this;
        }

        public final String getHookStatusMessage() {
            return hookStatusMessage;
        }

        public final void setHookStatusMessage(String hookStatusMessage) {
            this.hookStatusMessage = hookStatusMessage;
        }

        @Override
        public final Builder hookStatusMessage(String hookStatusMessage) {
            this.hookStatusMessage = hookStatusMessage;
            return this;
        }

        public final String getFailureMode() {
            return failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public HookProgressEvent build() {
            return new HookProgressEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
