/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.cloudcontrol.CloudControlClient;
import software.amazon.awssdk.services.cloudcontrol.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlRequest;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusRequest;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse;
import software.amazon.awssdk.services.cloudcontrol.waiters.CloudControlWaiter;
import software.amazon.awssdk.services.cloudcontrol.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultCloudControlWaiter
implements CloudControlWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final CloudControlClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetResourceRequestStatusResponse> resourceRequestSuccessWaiter;

    private DefaultCloudControlWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CloudControlClient)CloudControlClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.resourceRequestSuccessWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetResourceRequestStatusResponse.class).acceptors(DefaultCloudControlWaiter.resourceRequestSuccessWaiterAcceptors())).overrideConfiguration(DefaultCloudControlWaiter.resourceRequestSuccessWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetResourceRequestStatusResponse> waitUntilResourceRequestSuccess(GetResourceRequestStatusRequest getResourceRequestStatusRequest) {
        return this.resourceRequestSuccessWaiter.run(() -> this.client.getResourceRequestStatus(this.applyWaitersUserAgent(getResourceRequestStatusRequest)));
    }

    @Override
    public WaiterResponse<GetResourceRequestStatusResponse> waitUntilResourceRequestSuccess(GetResourceRequestStatusRequest getResourceRequestStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.resourceRequestSuccessWaiter.run(() -> this.client.getResourceRequestStatus(this.applyWaitersUserAgent(getResourceRequestStatusRequest)), DefaultCloudControlWaiter.resourceRequestSuccessWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetResourceRequestStatusResponse>> resourceRequestSuccessWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetResourceRequestStatusResponse>> result = new ArrayList<WaiterAcceptor<? super GetResourceRequestStatusResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ProgressEvent").field("OperationStatus").value(), "SUCCESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ProgressEvent").field("OperationStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ProgressEvent.OperationStatus=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ProgressEvent").field("OperationStatus").value(), "CANCEL_COMPLETE");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ProgressEvent.OperationStatus=CANCEL_COMPLETE) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration resourceRequestSuccessWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(24);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CloudControlWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CloudControlRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudControlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CloudControlWaiter.Builder {
        private CloudControlClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public CloudControlWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CloudControlWaiter.Builder client(CloudControlClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CloudControlWaiter build() {
            return new DefaultCloudControlWaiter(this);
        }
    }
}

