/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudcontrol.CloudControlClientBuilder;
import software.amazon.awssdk.services.cloudcontrol.DefaultCloudControlClientBuilder;
import software.amazon.awssdk.services.cloudcontrol.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestRequest;
import software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ClientTokenConflictException;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlException;
import software.amazon.awssdk.services.cloudcontrol.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudcontrol.model.ConcurrentOperationException;
import software.amazon.awssdk.services.cloudcontrol.model.CreateResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.CreateResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.GeneralServiceException;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusRequest;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.HandlerFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.HandlerInternalFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.InvalidCredentialsException;
import software.amazon.awssdk.services.cloudcontrol.model.InvalidRequestException;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourcesRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourcesResponse;
import software.amazon.awssdk.services.cloudcontrol.model.NetworkFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.NotStabilizedException;
import software.amazon.awssdk.services.cloudcontrol.model.NotUpdatableException;
import software.amazon.awssdk.services.cloudcontrol.model.PrivateTypeException;
import software.amazon.awssdk.services.cloudcontrol.model.RequestTokenNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceConflictException;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.ServiceInternalErrorException;
import software.amazon.awssdk.services.cloudcontrol.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.cloudcontrol.model.ThrottlingException;
import software.amazon.awssdk.services.cloudcontrol.model.TypeNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.UnsupportedActionException;
import software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.paginators.ListResourceRequestsIterable;
import software.amazon.awssdk.services.cloudcontrol.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.cloudcontrol.waiters.CloudControlWaiter;

@SdkPublicApi
@ThreadSafe
public interface CloudControlClient
extends SdkClient {
    public static final String SERVICE_NAME = "cloudcontrolapi";
    public static final String SERVICE_METADATA_ID = "cloudcontrolapi";

    public static CloudControlClient create() {
        return (CloudControlClient)CloudControlClient.builder().build();
    }

    public static CloudControlClientBuilder builder() {
        return new DefaultCloudControlClientBuilder();
    }

    default public CancelResourceRequestResponse cancelResourceRequest(CancelResourceRequestRequest cancelResourceRequestRequest) throws ConcurrentModificationException, RequestTokenNotFoundException, AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public CancelResourceRequestResponse cancelResourceRequest(Consumer<CancelResourceRequestRequest.Builder> cancelResourceRequestRequest) throws ConcurrentModificationException, RequestTokenNotFoundException, AwsServiceException, SdkClientException, CloudControlException {
        return this.cancelResourceRequest((CancelResourceRequestRequest)((Object)((CancelResourceRequestRequest.Builder)CancelResourceRequestRequest.builder().applyMutation(cancelResourceRequestRequest)).build()));
    }

    default public CreateResourceResponse createResource(CreateResourceRequest createResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public CreateResourceResponse createResource(Consumer<CreateResourceRequest.Builder> createResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        return this.createResource((CreateResourceRequest)((Object)((CreateResourceRequest.Builder)CreateResourceRequest.builder().applyMutation(createResourceRequest)).build()));
    }

    default public DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public DeleteResourceResponse deleteResource(Consumer<DeleteResourceRequest.Builder> deleteResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        return this.deleteResource((DeleteResourceRequest)((Object)((DeleteResourceRequest.Builder)DeleteResourceRequest.builder().applyMutation(deleteResourceRequest)).build()));
    }

    default public GetResourceResponse getResource(GetResourceRequest getResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public GetResourceResponse getResource(Consumer<GetResourceRequest.Builder> getResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        return this.getResource((GetResourceRequest)((Object)((GetResourceRequest.Builder)GetResourceRequest.builder().applyMutation(getResourceRequest)).build()));
    }

    default public GetResourceRequestStatusResponse getResourceRequestStatus(GetResourceRequestStatusRequest getResourceRequestStatusRequest) throws RequestTokenNotFoundException, AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public GetResourceRequestStatusResponse getResourceRequestStatus(Consumer<GetResourceRequestStatusRequest.Builder> getResourceRequestStatusRequest) throws RequestTokenNotFoundException, AwsServiceException, SdkClientException, CloudControlException {
        return this.getResourceRequestStatus((GetResourceRequestStatusRequest)((Object)((GetResourceRequestStatusRequest.Builder)GetResourceRequestStatusRequest.builder().applyMutation(getResourceRequestStatusRequest)).build()));
    }

    default public ListResourceRequestsResponse listResourceRequests(ListResourceRequestsRequest listResourceRequestsRequest) throws AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public ListResourceRequestsResponse listResourceRequests(Consumer<ListResourceRequestsRequest.Builder> listResourceRequestsRequest) throws AwsServiceException, SdkClientException, CloudControlException {
        return this.listResourceRequests((ListResourceRequestsRequest)((Object)((ListResourceRequestsRequest.Builder)ListResourceRequestsRequest.builder().applyMutation(listResourceRequestsRequest)).build()));
    }

    default public ListResourceRequestsIterable listResourceRequestsPaginator(ListResourceRequestsRequest listResourceRequestsRequest) throws AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public ListResourceRequestsIterable listResourceRequestsPaginator(Consumer<ListResourceRequestsRequest.Builder> listResourceRequestsRequest) throws AwsServiceException, SdkClientException, CloudControlException {
        return this.listResourceRequestsPaginator((ListResourceRequestsRequest)((Object)((ListResourceRequestsRequest.Builder)ListResourceRequestsRequest.builder().applyMutation(listResourceRequestsRequest)).build()));
    }

    default public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public ListResourcesResponse listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        return this.listResources((ListResourcesRequest)((Object)((ListResourcesRequest.Builder)ListResourcesRequest.builder().applyMutation(listResourcesRequest)).build()));
    }

    default public ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public ListResourcesIterable listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        return this.listResourcesPaginator((ListResourcesRequest)((Object)((ListResourcesRequest.Builder)ListResourcesRequest.builder().applyMutation(listResourcesRequest)).build()));
    }

    default public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        throw new UnsupportedOperationException();
    }

    default public UpdateResourceResponse updateResource(Consumer<UpdateResourceRequest.Builder> updateResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        return this.updateResource((UpdateResourceRequest)((Object)((UpdateResourceRequest.Builder)UpdateResourceRequest.builder().applyMutation(updateResourceRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"cloudcontrolapi");
    }

    default public CloudControlWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}

