/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentsResponse extends Cloud9Response implements
        ToCopyableBuilder<ListEnvironmentsResponse.Builder, ListEnvironmentsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> ENVIRONMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListEnvironmentsResponse::environmentIds))
            .setter(setter(Builder::environmentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ENVIRONMENT_IDS_FIELD));

    private final String nextToken;

    private final List<String> environmentIds;

    private ListEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.environmentIds = builder.environmentIds;
    }

    /**
     * <p>
     * If there are more than 25 items in the list, only the first 25 items are returned, along with a unique string
     * called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the
     * next token to the call.
     * </p>
     * 
     * @return If there are more than 25 items in the list, only the first 25 items are returned, along with a unique
     *         string called a <i>next token</i>. To get the next batch of items in the list, call this operation again,
     *         adding the next token to the call.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the EnvironmentIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEnvironmentIds() {
        return environmentIds != null && !(environmentIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of environment identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironmentIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of environment identifiers.
     */
    public List<String> environmentIds() {
        return environmentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsResponse)) {
            return false;
        }
        ListEnvironmentsResponse other = (ListEnvironmentsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(environmentIds(), other.environmentIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEnvironmentsResponse").add("NextToken", nextToken()).add("EnvironmentIds", environmentIds())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "environmentIds":
            return Optional.ofNullable(clazz.cast(environmentIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Response.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentsResponse> {
        /**
         * <p>
         * If there are more than 25 items in the list, only the first 25 items are returned, along with a unique string
         * called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the
         * next token to the call.
         * </p>
         * 
         * @param nextToken
         *        If there are more than 25 items in the list, only the first 25 items are returned, along with a unique
         *        string called a <i>next token</i>. To get the next batch of items in the list, call this operation
         *        again, adding the next token to the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of environment identifiers.
         * </p>
         * 
         * @param environmentIds
         *        The list of environment identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIds(Collection<String> environmentIds);

        /**
         * <p>
         * The list of environment identifiers.
         * </p>
         * 
         * @param environmentIds
         *        The list of environment identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIds(String... environmentIds);
    }

    static final class BuilderImpl extends Cloud9Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<String> environmentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsResponse model) {
            super(model);
            nextToken(model.nextToken);
            environmentIds(model.environmentIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getEnvironmentIds() {
            return environmentIds;
        }

        @Override
        public final Builder environmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentIds(String... environmentIds) {
            environmentIds(Arrays.asList(environmentIds));
            return this;
        }

        public final void setEnvironmentIds(Collection<String> environmentIds) {
            this.environmentIds = EnvironmentIdListCopier.copy(environmentIds);
        }

        @Override
        public ListEnvironmentsResponse build() {
            return new ListEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
