/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.cloud9.transform.ListEnvironmentsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListEnvironmentsRequestMarshaller
implements Marshaller<Request<ListEnvironmentsRequest>, ListEnvironmentsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSCloud9WorkspaceManagementService.ListEnvironments").serviceName("AWS Cloud9").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public ListEnvironmentsRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListEnvironmentsRequest> marshall(ListEnvironmentsRequest listEnvironmentsRequest) {
        Validate.paramNotNull((Object)((Object)listEnvironmentsRequest), (String)"listEnvironmentsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)listEnvironmentsRequest);
            protocolMarshaller.startMarshalling();
            ListEnvironmentsRequestModelMarshaller.getInstance().marshall(listEnvironmentsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

