/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.cloud9.transform.DeleteEnvironmentRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeleteEnvironmentRequestMarshaller
implements Marshaller<Request<DeleteEnvironmentRequest>, DeleteEnvironmentRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSCloud9WorkspaceManagementService.DeleteEnvironment").serviceName("AWS Cloud9").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DeleteEnvironmentRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteEnvironmentRequest> marshall(DeleteEnvironmentRequest deleteEnvironmentRequest) {
        Validate.paramNotNull((Object)((Object)deleteEnvironmentRequest), (String)"deleteEnvironmentRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)deleteEnvironmentRequest);
            protocolMarshaller.startMarshalling();
            DeleteEnvironmentRequestModelMarshaller.getInstance().marshall(deleteEnvironmentRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

