/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the trained model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainedModelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainedModelSummary.Builder, TrainedModelSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(TrainedModelSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(TrainedModelSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(TrainedModelSummary::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> VERSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionIdentifier").getter(getter(TrainedModelSummary::versionIdentifier))
            .setter(setter(Builder::versionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionIdentifier").build()).build();

    private static final SdkField<List<IncrementalTrainingDataChannelOutput>> INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD = SdkField
            .<List<IncrementalTrainingDataChannelOutput>> builder(MarshallingType.LIST)
            .memberName("incrementalTrainingDataChannels")
            .getter(getter(TrainedModelSummary::incrementalTrainingDataChannels))
            .setter(setter(Builder::incrementalTrainingDataChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalTrainingDataChannels")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncrementalTrainingDataChannelOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncrementalTrainingDataChannelOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TrainedModelSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TrainedModelSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(TrainedModelSummary::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(TrainedModelSummary::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TrainedModelSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(TrainedModelSummary::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, TRAINED_MODEL_ARN_FIELD, VERSION_IDENTIFIER_FIELD, INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, STATUS_FIELD,
            CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createTime;

    private final Instant updateTime;

    private final String trainedModelArn;

    private final String versionIdentifier;

    private final List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels;

    private final String name;

    private final String description;

    private final String membershipIdentifier;

    private final String collaborationIdentifier;

    private final String status;

    private final String configuredModelAlgorithmAssociationArn;

    private TrainedModelSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.trainedModelArn = builder.trainedModelArn;
        this.versionIdentifier = builder.versionIdentifier;
        this.incrementalTrainingDataChannels = builder.incrementalTrainingDataChannels;
        this.name = builder.name;
        this.description = builder.description;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.status = builder.status;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
    }

    /**
     * <p>
     * The time at which the trained model was created.
     * </p>
     * 
     * @return The time at which the trained model was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the trained model was updated.
     * </p>
     * 
     * @return The most recent time at which the trained model was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The version identifier of this trained model version.
     * </p>
     * 
     * @return The version identifier of this trained model version.
     */
    public final String versionIdentifier() {
        return versionIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncrementalTrainingDataChannels
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasIncrementalTrainingDataChannels() {
        return incrementalTrainingDataChannels != null && !(incrementalTrainingDataChannels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the incremental training data channels used to create this version of the trained model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncrementalTrainingDataChannels}
     * method.
     * </p>
     * 
     * @return Information about the incremental training data channels used to create this version of the trained
     *         model.
     */
    public final List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels() {
        return incrementalTrainingDataChannels;
    }

    /**
     * <p>
     * The name of the trained model.
     * </p>
     * 
     * @return The name of the trained model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the trained model.
     * </p>
     * 
     * @return The description of the trained model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The membership ID of the member that created the trained model.
     * </p>
     * 
     * @return The membership ID of the member that created the trained model.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The collaboration ID of the collaboration that contains the trained model.
     * </p>
     * 
     * @return The collaboration ID of the collaboration that contains the trained model.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The status of the trained model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model.
     * @see TrainedModelStatus
     */
    public final TrainedModelStatus status() {
        return TrainedModelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the trained model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model.
     * @see TrainedModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create this trained
     * model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create this
     *         trained model.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionIdentifier());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIncrementalTrainingDataChannels() ? incrementalTrainingDataChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelSummary)) {
            return false;
        }
        TrainedModelSummary other = (TrainedModelSummary) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(versionIdentifier(), other.versionIdentifier())
                && hasIncrementalTrainingDataChannels() == other.hasIncrementalTrainingDataChannels()
                && Objects.equals(incrementalTrainingDataChannels(), other.incrementalTrainingDataChannels())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("TrainedModelSummary")
                .add("CreateTime", createTime())
                .add("UpdateTime", updateTime())
                .add("TrainedModelArn", trainedModelArn())
                .add("VersionIdentifier", versionIdentifier())
                .add("IncrementalTrainingDataChannels",
                        hasIncrementalTrainingDataChannels() ? incrementalTrainingDataChannels() : null).add("Name", name())
                .add("Description", description()).add("MembershipIdentifier", membershipIdentifier())
                .add("CollaborationIdentifier", collaborationIdentifier()).add("Status", statusAsString())
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "versionIdentifier":
            return Optional.ofNullable(clazz.cast(versionIdentifier()));
        case "incrementalTrainingDataChannels":
            return Optional.ofNullable(clazz.cast(incrementalTrainingDataChannels()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("versionIdentifier", VERSION_IDENTIFIER_FIELD);
        map.put("incrementalTrainingDataChannels", INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelSummary, T> g) {
        return obj -> g.apply((TrainedModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainedModelSummary> {
        /**
         * <p>
         * The time at which the trained model was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the trained model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the trained model was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the trained model was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The version identifier of this trained model version.
         * </p>
         * 
         * @param versionIdentifier
         *        The version identifier of this trained model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdentifier(String versionIdentifier);

        /**
         * <p>
         * Information about the incremental training data channels used to create this version of the trained model.
         * </p>
         * 
         * @param incrementalTrainingDataChannels
         *        Information about the incremental training data channels used to create this version of the trained
         *        model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalTrainingDataChannels(Collection<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels);

        /**
         * <p>
         * Information about the incremental training data channels used to create this version of the trained model.
         * </p>
         * 
         * @param incrementalTrainingDataChannels
         *        Information about the incremental training data channels used to create this version of the trained
         *        model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalTrainingDataChannels(IncrementalTrainingDataChannelOutput... incrementalTrainingDataChannels);

        /**
         * <p>
         * Information about the incremental training data channels used to create this version of the trained model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #incrementalTrainingDataChannels(List<IncrementalTrainingDataChannelOutput>)}.
         * 
         * @param incrementalTrainingDataChannels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalTrainingDataChannels(java.util.Collection<IncrementalTrainingDataChannelOutput>)
         */
        Builder incrementalTrainingDataChannels(
                Consumer<IncrementalTrainingDataChannelOutput.Builder>... incrementalTrainingDataChannels);

        /**
         * <p>
         * The name of the trained model.
         * </p>
         * 
         * @param name
         *        The name of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the trained model.
         * </p>
         * 
         * @param description
         *        The description of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The membership ID of the member that created the trained model.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that created the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The collaboration ID of the collaboration that contains the trained model.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The collaboration ID of the collaboration that contains the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The status of the trained model.
         * </p>
         * 
         * @param status
         *        The status of the trained model.
         * @see TrainedModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the trained model.
         * </p>
         * 
         * @param status
         *        The status of the trained model.
         * @see TrainedModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelStatus
         */
        Builder status(TrainedModelStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create this
         * trained model.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create
         *        this trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String trainedModelArn;

        private String versionIdentifier;

        private List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels = DefaultSdkAutoConstructList
                .getInstance();

        private String name;

        private String description;

        private String membershipIdentifier;

        private String collaborationIdentifier;

        private String status;

        private String configuredModelAlgorithmAssociationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelSummary model) {
            createTime(model.createTime);
            updateTime(model.updateTime);
            trainedModelArn(model.trainedModelArn);
            versionIdentifier(model.versionIdentifier);
            incrementalTrainingDataChannels(model.incrementalTrainingDataChannels);
            name(model.name);
            description(model.description);
            membershipIdentifier(model.membershipIdentifier);
            collaborationIdentifier(model.collaborationIdentifier);
            status(model.status);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getVersionIdentifier() {
            return versionIdentifier;
        }

        public final void setVersionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
        }

        @Override
        public final Builder versionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
            return this;
        }

        public final List<IncrementalTrainingDataChannelOutput.Builder> getIncrementalTrainingDataChannels() {
            List<IncrementalTrainingDataChannelOutput.Builder> result = IncrementalTrainingDataChannelsOutputCopier
                    .copyToBuilder(this.incrementalTrainingDataChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncrementalTrainingDataChannels(
                Collection<IncrementalTrainingDataChannelOutput.BuilderImpl> incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels = IncrementalTrainingDataChannelsOutputCopier
                    .copyFromBuilder(incrementalTrainingDataChannels);
        }

        @Override
        public final Builder incrementalTrainingDataChannels(
                Collection<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels = IncrementalTrainingDataChannelsOutputCopier
                    .copy(incrementalTrainingDataChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incrementalTrainingDataChannels(
                IncrementalTrainingDataChannelOutput... incrementalTrainingDataChannels) {
            incrementalTrainingDataChannels(Arrays.asList(incrementalTrainingDataChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incrementalTrainingDataChannels(
                Consumer<IncrementalTrainingDataChannelOutput.Builder>... incrementalTrainingDataChannels) {
            incrementalTrainingDataChannels(Stream.of(incrementalTrainingDataChannels)
                    .map(c -> IncrementalTrainingDataChannelOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        @Override
        public TrainedModelSummary build() {
            return new TrainedModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
