/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the output of the trained model export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainedModelExportOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainedModelExportOutputConfiguration.Builder, TrainedModelExportOutputConfiguration> {
    private static final SdkField<List<TrainedModelExportReceiverMember>> MEMBERS_FIELD = SdkField
            .<List<TrainedModelExportReceiverMember>> builder(MarshallingType.LIST)
            .memberName("members")
            .getter(getter(TrainedModelExportOutputConfiguration::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrainedModelExportReceiverMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrainedModelExportReceiverMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TrainedModelExportReceiverMember> members;

    private TrainedModelExportOutputConfiguration(BuilderImpl builder) {
        this.members = builder.members;
    }

    /**
     * For responses, this returns true if the service returned a value for the Members property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The members that will received the exported trained model output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembers} method.
     * </p>
     * 
     * @return The members that will received the exported trained model output.
     */
    public final List<TrainedModelExportReceiverMember> members() {
        return members;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelExportOutputConfiguration)) {
            return false;
        }
        TrainedModelExportOutputConfiguration other = (TrainedModelExportOutputConfiguration) obj;
        return hasMembers() == other.hasMembers() && Objects.equals(members(), other.members());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainedModelExportOutputConfiguration").add("Members", hasMembers() ? members() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "members":
            return Optional.ofNullable(clazz.cast(members()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("members", MEMBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelExportOutputConfiguration, T> g) {
        return obj -> g.apply((TrainedModelExportOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainedModelExportOutputConfiguration> {
        /**
         * <p>
         * The members that will received the exported trained model output.
         * </p>
         * 
         * @param members
         *        The members that will received the exported trained model output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<TrainedModelExportReceiverMember> members);

        /**
         * <p>
         * The members that will received the exported trained model output.
         * </p>
         * 
         * @param members
         *        The members that will received the exported trained model output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(TrainedModelExportReceiverMember... members);

        /**
         * <p>
         * The members that will received the exported trained model output.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportReceiverMember.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportReceiverMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportReceiverMember.Builder#build()}
         * is called immediately and its result is passed to {@link #members(List<TrainedModelExportReceiverMember>)}.
         * 
         * @param members
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelExportReceiverMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(java.util.Collection<TrainedModelExportReceiverMember>)
         */
        Builder members(Consumer<TrainedModelExportReceiverMember.Builder>... members);
    }

    static final class BuilderImpl implements Builder {
        private List<TrainedModelExportReceiverMember> members = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelExportOutputConfiguration model) {
            members(model.members);
        }

        public final List<TrainedModelExportReceiverMember.Builder> getMembers() {
            List<TrainedModelExportReceiverMember.Builder> result = TrainedModelExportReceiverMembersCopier
                    .copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<TrainedModelExportReceiverMember.BuilderImpl> members) {
            this.members = TrainedModelExportReceiverMembersCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<TrainedModelExportReceiverMember> members) {
            this.members = TrainedModelExportReceiverMembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(TrainedModelExportReceiverMember... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<TrainedModelExportReceiverMember.Builder>... members) {
            members(Stream.of(members).map(c -> TrainedModelExportReceiverMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TrainedModelExportOutputConfiguration build() {
            return new TrainedModelExportOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
