/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You have exceeded your service quota.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceQuotaExceededException extends CleanRoomsMlException implements
        ToCopyableBuilder<ServiceQuotaExceededException.Builder, ServiceQuotaExceededException> {
    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quotaName").getter(getter(ServiceQuotaExceededException::quotaName)).setter(setter(Builder::quotaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quotaName").build()).build();

    private static final SdkField<Double> QUOTA_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("quotaValue").getter(getter(ServiceQuotaExceededException::quotaValue))
            .setter(setter(Builder::quotaValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quotaValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUOTA_NAME_FIELD,
            QUOTA_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String quotaName;

    private final Double quotaValue;

    private ServiceQuotaExceededException(BuilderImpl builder) {
        super(builder);
        this.quotaName = builder.quotaName;
        this.quotaValue = builder.quotaValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The name of the service quota limit that was exceeded
     * </p>
     * 
     * @return The name of the service quota limit that was exceeded
     */
    public String quotaName() {
        return quotaName;
    }

    /**
     * <p>
     * The current limit on the service quota that was exceeded
     * </p>
     * 
     * @return The current limit on the service quota that was exceeded
     */
    public Double quotaValue() {
        return quotaValue;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("quotaName", QUOTA_NAME_FIELD);
        map.put("quotaValue", QUOTA_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceQuotaExceededException, T> g) {
        return obj -> g.apply((ServiceQuotaExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceQuotaExceededException>,
            CleanRoomsMlException.Builder {
        /**
         * <p>
         * The name of the service quota limit that was exceeded
         * </p>
         * 
         * @param quotaName
         *        The name of the service quota limit that was exceeded
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaName(String quotaName);

        /**
         * <p>
         * The current limit on the service quota that was exceeded
         * </p>
         * 
         * @param quotaValue
         *        The current limit on the service quota that was exceeded
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaValue(Double quotaValue);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends CleanRoomsMlException.BuilderImpl implements Builder {
        private String quotaName;

        private Double quotaValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceQuotaExceededException model) {
            super(model);
            quotaName(model.quotaName);
            quotaValue(model.quotaValue);
        }

        public final String getQuotaName() {
            return quotaName;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        @Override
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public final Double getQuotaValue() {
            return quotaValue;
        }

        public final void setQuotaValue(Double quotaValue) {
            this.quotaValue = quotaValue;
        }

        @Override
        public final Builder quotaValue(Double quotaValue) {
            this.quotaValue = quotaValue;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ServiceQuotaExceededException build() {
            return new ServiceQuotaExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
