/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information necessary to perform the protected query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedQueryInputParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedQueryInputParameters.Builder, ProtectedQueryInputParameters> {
    private static final SdkField<ProtectedQuerySQLParameters> SQL_PARAMETERS_FIELD = SdkField
            .<ProtectedQuerySQLParameters> builder(MarshallingType.SDK_POJO).memberName("sqlParameters")
            .getter(getter(ProtectedQueryInputParameters::sqlParameters)).setter(setter(Builder::sqlParameters))
            .constructor(ProtectedQuerySQLParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlParameters").build()).build();

    private static final SdkField<ComputeConfiguration> COMPUTE_CONFIGURATION_FIELD = SdkField
            .<ComputeConfiguration> builder(MarshallingType.SDK_POJO).memberName("computeConfiguration")
            .getter(getter(ProtectedQueryInputParameters::computeConfiguration)).setter(setter(Builder::computeConfiguration))
            .constructor(ComputeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfiguration").build())
            .build();

    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resultFormat").getter(getter(ProtectedQueryInputParameters::resultFormatAsString))
            .setter(setter(Builder::resultFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_PARAMETERS_FIELD,
            COMPUTE_CONFIGURATION_FIELD, RESULT_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProtectedQuerySQLParameters sqlParameters;

    private final ComputeConfiguration computeConfiguration;

    private final String resultFormat;

    private ProtectedQueryInputParameters(BuilderImpl builder) {
        this.sqlParameters = builder.sqlParameters;
        this.computeConfiguration = builder.computeConfiguration;
        this.resultFormat = builder.resultFormat;
    }

    /**
     * Returns the value of the SqlParameters property for this object.
     * 
     * @return The value of the SqlParameters property for this object.
     */
    public final ProtectedQuerySQLParameters sqlParameters() {
        return sqlParameters;
    }

    /**
     * <p>
     * Provides configuration information for the workers that will perform the protected query.
     * </p>
     * 
     * @return Provides configuration information for the workers that will perform the protected query.
     */
    public final ComputeConfiguration computeConfiguration() {
        return computeConfiguration;
    }

    /**
     * <p>
     * The format in which the query results should be returned. If not specified, defaults to <code>CSV</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return The format in which the query results should be returned. If not specified, defaults to <code>CSV</code>.
     * @see ResultFormat
     */
    public final ResultFormat resultFormat() {
        return ResultFormat.fromValue(resultFormat);
    }

    /**
     * <p>
     * The format in which the query results should be returned. If not specified, defaults to <code>CSV</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return The format in which the query results should be returned. If not specified, defaults to <code>CSV</code>.
     * @see ResultFormat
     */
    public final String resultFormatAsString() {
        return resultFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(computeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(resultFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQueryInputParameters)) {
            return false;
        }
        ProtectedQueryInputParameters other = (ProtectedQueryInputParameters) obj;
        return Objects.equals(sqlParameters(), other.sqlParameters())
                && Objects.equals(computeConfiguration(), other.computeConfiguration())
                && Objects.equals(resultFormatAsString(), other.resultFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedQueryInputParameters")
                .add("SqlParameters", sqlParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ComputeConfiguration", computeConfiguration()).add("ResultFormat", resultFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sqlParameters":
            return Optional.ofNullable(clazz.cast(sqlParameters()));
        case "computeConfiguration":
            return Optional.ofNullable(clazz.cast(computeConfiguration()));
        case "resultFormat":
            return Optional.ofNullable(clazz.cast(resultFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sqlParameters", SQL_PARAMETERS_FIELD);
        map.put("computeConfiguration", COMPUTE_CONFIGURATION_FIELD);
        map.put("resultFormat", RESULT_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQueryInputParameters, T> g) {
        return obj -> g.apply((ProtectedQueryInputParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedQueryInputParameters> {
        /**
         * Sets the value of the SqlParameters property for this object.
         *
         * @param sqlParameters
         *        The new value for the SqlParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters);

        /**
         * Sets the value of the SqlParameters property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProtectedQuerySQLParameters.Builder}
         * avoiding the need to create one manually via {@link ProtectedQuerySQLParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQuerySQLParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #sqlParameters(ProtectedQuerySQLParameters)}.
         * 
         * @param sqlParameters
         *        a consumer that will call methods on {@link ProtectedQuerySQLParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlParameters(ProtectedQuerySQLParameters)
         */
        default Builder sqlParameters(Consumer<ProtectedQuerySQLParameters.Builder> sqlParameters) {
            return sqlParameters(ProtectedQuerySQLParameters.builder().applyMutation(sqlParameters).build());
        }

        /**
         * <p>
         * Provides configuration information for the workers that will perform the protected query.
         * </p>
         * 
         * @param computeConfiguration
         *        Provides configuration information for the workers that will perform the protected query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeConfiguration(ComputeConfiguration computeConfiguration);

        /**
         * <p>
         * Provides configuration information for the workers that will perform the protected query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeConfiguration.Builder} avoiding
         * the need to create one manually via {@link ComputeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #computeConfiguration(ComputeConfiguration)}.
         * 
         * @param computeConfiguration
         *        a consumer that will call methods on {@link ComputeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeConfiguration(ComputeConfiguration)
         */
        default Builder computeConfiguration(Consumer<ComputeConfiguration.Builder> computeConfiguration) {
            return computeConfiguration(ComputeConfiguration.builder().applyMutation(computeConfiguration).build());
        }

        /**
         * <p>
         * The format in which the query results should be returned. If not specified, defaults to <code>CSV</code>.
         * </p>
         * 
         * @param resultFormat
         *        The format in which the query results should be returned. If not specified, defaults to
         *        <code>CSV</code>.
         * @see ResultFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormat
         */
        Builder resultFormat(String resultFormat);

        /**
         * <p>
         * The format in which the query results should be returned. If not specified, defaults to <code>CSV</code>.
         * </p>
         * 
         * @param resultFormat
         *        The format in which the query results should be returned. If not specified, defaults to
         *        <code>CSV</code>.
         * @see ResultFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormat
         */
        Builder resultFormat(ResultFormat resultFormat);
    }

    static final class BuilderImpl implements Builder {
        private ProtectedQuerySQLParameters sqlParameters;

        private ComputeConfiguration computeConfiguration;

        private String resultFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQueryInputParameters model) {
            sqlParameters(model.sqlParameters);
            computeConfiguration(model.computeConfiguration);
            resultFormat(model.resultFormat);
        }

        public final ProtectedQuerySQLParameters.Builder getSqlParameters() {
            return sqlParameters != null ? sqlParameters.toBuilder() : null;
        }

        public final void setSqlParameters(ProtectedQuerySQLParameters.BuilderImpl sqlParameters) {
            this.sqlParameters = sqlParameters != null ? sqlParameters.build() : null;
        }

        @Override
        public final Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters) {
            this.sqlParameters = sqlParameters;
            return this;
        }

        public final ComputeConfiguration.Builder getComputeConfiguration() {
            return computeConfiguration != null ? computeConfiguration.toBuilder() : null;
        }

        public final void setComputeConfiguration(ComputeConfiguration.BuilderImpl computeConfiguration) {
            this.computeConfiguration = computeConfiguration != null ? computeConfiguration.build() : null;
        }

        @Override
        public final Builder computeConfiguration(ComputeConfiguration computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        public final String getResultFormat() {
            return resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormat resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        @Override
        public ProtectedQueryInputParameters build() {
            return new ProtectedQueryInputParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
