/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrainedModelResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetTrainedModelResponse.Builder, GetTrainedModelResponse> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(GetTrainedModelResponse::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(GetTrainedModelResponse::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(GetTrainedModelResponse::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> VERSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionIdentifier").getter(getter(GetTrainedModelResponse::versionIdentifier))
            .setter(setter(Builder::versionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionIdentifier").build()).build();

    private static final SdkField<List<IncrementalTrainingDataChannelOutput>> INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD = SdkField
            .<List<IncrementalTrainingDataChannelOutput>> builder(MarshallingType.LIST)
            .memberName("incrementalTrainingDataChannels")
            .getter(getter(GetTrainedModelResponse::incrementalTrainingDataChannels))
            .setter(setter(Builder::incrementalTrainingDataChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalTrainingDataChannels")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncrementalTrainingDataChannelOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncrementalTrainingDataChannelOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTrainedModelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetTrainedModelResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTrainedModelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField
            .<StatusDetails> builder(MarshallingType.SDK_POJO).memberName("statusDetails")
            .getter(getter(GetTrainedModelResponse::statusDetails)).setter(setter(Builder::statusDetails))
            .constructor(StatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(GetTrainedModelResponse::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<ResourceConfig> builder(MarshallingType.SDK_POJO).memberName("resourceConfig")
            .getter(getter(GetTrainedModelResponse::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(ResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()).build();

    private static final SdkField<String> TRAINING_INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingInputMode").getter(getter(GetTrainedModelResponse::trainingInputModeAsString))
            .setter(setter(Builder::trainingInputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingInputMode").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("stoppingCondition")
            .getter(getter(GetTrainedModelResponse::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingCondition").build()).build();

    private static final SdkField<String> METRICS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsStatus").getter(getter(GetTrainedModelResponse::metricsStatusAsString))
            .setter(setter(Builder::metricsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatus").build()).build();

    private static final SdkField<String> METRICS_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsStatusDetails").getter(getter(GetTrainedModelResponse::metricsStatusDetails))
            .setter(setter(Builder::metricsStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatusDetails").build())
            .build();

    private static final SdkField<String> LOGS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logsStatus").getter(getter(GetTrainedModelResponse::logsStatusAsString))
            .setter(setter(Builder::logsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatus").build()).build();

    private static final SdkField<String> LOGS_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logsStatusDetails").getter(getter(GetTrainedModelResponse::logsStatusDetails))
            .setter(setter(Builder::logsStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatusDetails").build()).build();

    private static final SdkField<String> TRAINING_CONTAINER_IMAGE_DIGEST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("trainingContainerImageDigest")
            .getter(getter(GetTrainedModelResponse::trainingContainerImageDigest))
            .setter(setter(Builder::trainingContainerImageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingContainerImageDigest")
                    .build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetTrainedModelResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetTrainedModelResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> HYPERPARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("hyperparameters")
            .getter(getter(GetTrainedModelResponse::hyperparameters))
            .setter(setter(Builder::hyperparameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperparameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environment")
            .getter(getter(GetTrainedModelResponse::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(GetTrainedModelResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetTrainedModelResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ModelTrainingDataChannel>> DATA_CHANNELS_FIELD = SdkField
            .<List<ModelTrainingDataChannel>> builder(MarshallingType.LIST)
            .memberName("dataChannels")
            .getter(getter(GetTrainedModelResponse::dataChannels))
            .setter(setter(Builder::dataChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataChannels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelTrainingDataChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelTrainingDataChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            COLLABORATION_IDENTIFIER_FIELD, TRAINED_MODEL_ARN_FIELD, VERSION_IDENTIFIER_FIELD,
            INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD,
            CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, RESOURCE_CONFIG_FIELD, TRAINING_INPUT_MODE_FIELD,
            STOPPING_CONDITION_FIELD, METRICS_STATUS_FIELD, METRICS_STATUS_DETAILS_FIELD, LOGS_STATUS_FIELD,
            LOGS_STATUS_DETAILS_FIELD, TRAINING_CONTAINER_IMAGE_DIGEST_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD,
            HYPERPARAMETERS_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD, DATA_CHANNELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String collaborationIdentifier;

    private final String trainedModelArn;

    private final String versionIdentifier;

    private final List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels;

    private final String name;

    private final String description;

    private final String status;

    private final StatusDetails statusDetails;

    private final String configuredModelAlgorithmAssociationArn;

    private final ResourceConfig resourceConfig;

    private final String trainingInputMode;

    private final StoppingCondition stoppingCondition;

    private final String metricsStatus;

    private final String metricsStatusDetails;

    private final String logsStatus;

    private final String logsStatusDetails;

    private final String trainingContainerImageDigest;

    private final Instant createTime;

    private final Instant updateTime;

    private final Map<String, String> hyperparameters;

    private final Map<String, String> environment;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private final List<ModelTrainingDataChannel> dataChannels;

    private GetTrainedModelResponse(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.trainedModelArn = builder.trainedModelArn;
        this.versionIdentifier = builder.versionIdentifier;
        this.incrementalTrainingDataChannels = builder.incrementalTrainingDataChannels;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.resourceConfig = builder.resourceConfig;
        this.trainingInputMode = builder.trainingInputMode;
        this.stoppingCondition = builder.stoppingCondition;
        this.metricsStatus = builder.metricsStatus;
        this.metricsStatusDetails = builder.metricsStatusDetails;
        this.logsStatus = builder.logsStatus;
        this.logsStatusDetails = builder.logsStatusDetails;
        this.trainingContainerImageDigest = builder.trainingContainerImageDigest;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.hyperparameters = builder.hyperparameters;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
        this.dataChannels = builder.dataChannels;
    }

    /**
     * <p>
     * The membership ID of the member that created the trained model.
     * </p>
     * 
     * @return The membership ID of the member that created the trained model.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The collaboration ID of the collaboration that contains the trained model.
     * </p>
     * 
     * @return The collaboration ID of the collaboration that contains the trained model.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The version identifier of the trained model. This unique identifier distinguishes this version from other
     * versions of the same trained model.
     * </p>
     * 
     * @return The version identifier of the trained model. This unique identifier distinguishes this version from other
     *         versions of the same trained model.
     */
    public final String versionIdentifier() {
        return versionIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncrementalTrainingDataChannels
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasIncrementalTrainingDataChannels() {
        return incrementalTrainingDataChannels != null && !(incrementalTrainingDataChannels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the incremental training data channels used to create this version of the trained model. This
     * includes details about the base model that was used for incremental training and the channel configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncrementalTrainingDataChannels}
     * method.
     * </p>
     * 
     * @return Information about the incremental training data channels used to create this version of the trained
     *         model. This includes details about the base model that was used for incremental training and the channel
     *         configuration.
     */
    public final List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels() {
        return incrementalTrainingDataChannels;
    }

    /**
     * <p>
     * The name of the trained model.
     * </p>
     * 
     * @return The name of the trained model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the trained model.
     * </p>
     * 
     * @return The description of the trained model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the trained model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model.
     * @see TrainedModelStatus
     */
    public final TrainedModelStatus status() {
        return TrainedModelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the trained model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model.
     * @see TrainedModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the StatusDetails property for this object.
     * 
     * @return The value of the StatusDetails property for this object.
     */
    public final StatusDetails statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create the trained
     * model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create the
     *         trained model.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    /**
     * <p>
     * The EC2 resource configuration that was used to create the trained model.
     * </p>
     * 
     * @return The EC2 resource configuration that was used to create the trained model.
     */
    public final ResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * The input mode that was used for accessing the training data when this trained model was created. This indicates
     * how the training data was made available to the training algorithm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingInputMode}
     * will return {@link TrainingInputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingInputModeAsString}.
     * </p>
     * 
     * @return The input mode that was used for accessing the training data when this trained model was created. This
     *         indicates how the training data was made available to the training algorithm.
     * @see TrainingInputMode
     */
    public final TrainingInputMode trainingInputMode() {
        return TrainingInputMode.fromValue(trainingInputMode);
    }

    /**
     * <p>
     * The input mode that was used for accessing the training data when this trained model was created. This indicates
     * how the training data was made available to the training algorithm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingInputMode}
     * will return {@link TrainingInputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingInputModeAsString}.
     * </p>
     * 
     * @return The input mode that was used for accessing the training data when this trained model was created. This
     *         indicates how the training data was made available to the training algorithm.
     * @see TrainingInputMode
     */
    public final String trainingInputModeAsString() {
        return trainingInputMode;
    }

    /**
     * <p>
     * The stopping condition that was used to terminate model training.
     * </p>
     * 
     * @return The stopping condition that was used to terminate model training.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * <p>
     * The status of the model metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsStatus}
     * will return {@link MetricsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricsStatusAsString}.
     * </p>
     * 
     * @return The status of the model metrics.
     * @see MetricsStatus
     */
    public final MetricsStatus metricsStatus() {
        return MetricsStatus.fromValue(metricsStatus);
    }

    /**
     * <p>
     * The status of the model metrics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsStatus}
     * will return {@link MetricsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricsStatusAsString}.
     * </p>
     * 
     * @return The status of the model metrics.
     * @see MetricsStatus
     */
    public final String metricsStatusAsString() {
        return metricsStatus;
    }

    /**
     * <p>
     * Details about the metrics status for the trained model.
     * </p>
     * 
     * @return Details about the metrics status for the trained model.
     */
    public final String metricsStatusDetails() {
        return metricsStatusDetails;
    }

    /**
     * <p>
     * The logs status for the trained model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logsStatus} will
     * return {@link LogsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logsStatusAsString}.
     * </p>
     * 
     * @return The logs status for the trained model.
     * @see LogsStatus
     */
    public final LogsStatus logsStatus() {
        return LogsStatus.fromValue(logsStatus);
    }

    /**
     * <p>
     * The logs status for the trained model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logsStatus} will
     * return {@link LogsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logsStatusAsString}.
     * </p>
     * 
     * @return The logs status for the trained model.
     * @see LogsStatus
     */
    public final String logsStatusAsString() {
        return logsStatus;
    }

    /**
     * <p>
     * Details about the logs status for the trained model.
     * </p>
     * 
     * @return Details about the logs status for the trained model.
     */
    public final String logsStatusDetails() {
        return logsStatusDetails;
    }

    /**
     * <p>
     * Information about the training image container.
     * </p>
     * 
     * @return Information about the training image container.
     */
    public final String trainingContainerImageDigest() {
        return trainingContainerImageDigest;
    }

    /**
     * <p>
     * The time at which the trained model was created.
     * </p>
     * 
     * @return The time at which the trained model was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the trained model was updated.
     * </p>
     * 
     * @return The most recent time at which the trained model was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hyperparameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHyperparameters() {
        return hyperparameters != null && !(hyperparameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The hyperparameters that were used to create the trained model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHyperparameters} method.
     * </p>
     * 
     * @return The hyperparameters that were used to create the trained model.
     */
    public final Map<String, String> hyperparameters() {
        return hyperparameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The EC2 environment that was used to create the trained model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The EC2 environment that was used to create the trained model.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the
     * trained ML model and associated data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
     *         data in the trained ML model and associated data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
     * consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the
     * limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user
     *         tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataChannels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataChannels() {
        return dataChannels != null && !(dataChannels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data channels that were used for the trained model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataChannels} method.
     * </p>
     * 
     * @return The data channels that were used for the trained model.
     */
    public final List<ModelTrainingDataChannel> dataChannels() {
        return dataChannels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(versionIdentifier());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIncrementalTrainingDataChannels() ? incrementalTrainingDataChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingInputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(metricsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(logsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(trainingContainerImageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperparameters() ? hyperparameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataChannels() ? dataChannels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrainedModelResponse)) {
            return false;
        }
        GetTrainedModelResponse other = (GetTrainedModelResponse) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(versionIdentifier(), other.versionIdentifier())
                && hasIncrementalTrainingDataChannels() == other.hasIncrementalTrainingDataChannels()
                && Objects.equals(incrementalTrainingDataChannels(), other.incrementalTrainingDataChannels())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn())
                && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(trainingInputModeAsString(), other.trainingInputModeAsString())
                && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && Objects.equals(metricsStatusAsString(), other.metricsStatusAsString())
                && Objects.equals(metricsStatusDetails(), other.metricsStatusDetails())
                && Objects.equals(logsStatusAsString(), other.logsStatusAsString())
                && Objects.equals(logsStatusDetails(), other.logsStatusDetails())
                && Objects.equals(trainingContainerImageDigest(), other.trainingContainerImageDigest())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && hasHyperparameters() == other.hasHyperparameters()
                && Objects.equals(hyperparameters(), other.hyperparameters()) && hasEnvironment() == other.hasEnvironment()
                && Objects.equals(environment(), other.environment()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasDataChannels() == other.hasDataChannels() && Objects.equals(dataChannels(), other.dataChannels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetTrainedModelResponse")
                .add("MembershipIdentifier", membershipIdentifier())
                .add("CollaborationIdentifier", collaborationIdentifier())
                .add("TrainedModelArn", trainedModelArn())
                .add("VersionIdentifier", versionIdentifier())
                .add("IncrementalTrainingDataChannels",
                        hasIncrementalTrainingDataChannels() ? incrementalTrainingDataChannels() : null).add("Name", name())
                .add("Description", description()).add("Status", statusAsString()).add("StatusDetails", statusDetails())
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn())
                .add("ResourceConfig", resourceConfig()).add("TrainingInputMode", trainingInputModeAsString())
                .add("StoppingCondition", stoppingCondition()).add("MetricsStatus", metricsStatusAsString())
                .add("MetricsStatusDetails", metricsStatusDetails()).add("LogsStatus", logsStatusAsString())
                .add("LogsStatusDetails", logsStatusDetails())
                .add("TrainingContainerImageDigest", trainingContainerImageDigest()).add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).add("Hyperparameters", hasHyperparameters() ? hyperparameters() : null)
                .add("Environment", hasEnvironment() ? environment() : null).add("KmsKeyArn", kmsKeyArn())
                .add("Tags", hasTags() ? tags() : null).add("DataChannels", hasDataChannels() ? dataChannels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "versionIdentifier":
            return Optional.ofNullable(clazz.cast(versionIdentifier()));
        case "incrementalTrainingDataChannels":
            return Optional.ofNullable(clazz.cast(incrementalTrainingDataChannels()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        case "resourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "trainingInputMode":
            return Optional.ofNullable(clazz.cast(trainingInputModeAsString()));
        case "stoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "metricsStatus":
            return Optional.ofNullable(clazz.cast(metricsStatusAsString()));
        case "metricsStatusDetails":
            return Optional.ofNullable(clazz.cast(metricsStatusDetails()));
        case "logsStatus":
            return Optional.ofNullable(clazz.cast(logsStatusAsString()));
        case "logsStatusDetails":
            return Optional.ofNullable(clazz.cast(logsStatusDetails()));
        case "trainingContainerImageDigest":
            return Optional.ofNullable(clazz.cast(trainingContainerImageDigest()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "hyperparameters":
            return Optional.ofNullable(clazz.cast(hyperparameters()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "dataChannels":
            return Optional.ofNullable(clazz.cast(dataChannels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("versionIdentifier", VERSION_IDENTIFIER_FIELD);
        map.put("incrementalTrainingDataChannels", INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("resourceConfig", RESOURCE_CONFIG_FIELD);
        map.put("trainingInputMode", TRAINING_INPUT_MODE_FIELD);
        map.put("stoppingCondition", STOPPING_CONDITION_FIELD);
        map.put("metricsStatus", METRICS_STATUS_FIELD);
        map.put("metricsStatusDetails", METRICS_STATUS_DETAILS_FIELD);
        map.put("logsStatus", LOGS_STATUS_FIELD);
        map.put("logsStatusDetails", LOGS_STATUS_DETAILS_FIELD);
        map.put("trainingContainerImageDigest", TRAINING_CONTAINER_IMAGE_DIGEST_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("hyperparameters", HYPERPARAMETERS_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("dataChannels", DATA_CHANNELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTrainedModelResponse, T> g) {
        return obj -> g.apply((GetTrainedModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTrainedModelResponse> {
        /**
         * <p>
         * The membership ID of the member that created the trained model.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that created the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The collaboration ID of the collaboration that contains the trained model.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The collaboration ID of the collaboration that contains the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The version identifier of the trained model. This unique identifier distinguishes this version from other
         * versions of the same trained model.
         * </p>
         * 
         * @param versionIdentifier
         *        The version identifier of the trained model. This unique identifier distinguishes this version from
         *        other versions of the same trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdentifier(String versionIdentifier);

        /**
         * <p>
         * Information about the incremental training data channels used to create this version of the trained model.
         * This includes details about the base model that was used for incremental training and the channel
         * configuration.
         * </p>
         * 
         * @param incrementalTrainingDataChannels
         *        Information about the incremental training data channels used to create this version of the trained
         *        model. This includes details about the base model that was used for incremental training and the
         *        channel configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalTrainingDataChannels(Collection<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels);

        /**
         * <p>
         * Information about the incremental training data channels used to create this version of the trained model.
         * This includes details about the base model that was used for incremental training and the channel
         * configuration.
         * </p>
         * 
         * @param incrementalTrainingDataChannels
         *        Information about the incremental training data channels used to create this version of the trained
         *        model. This includes details about the base model that was used for incremental training and the
         *        channel configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalTrainingDataChannels(IncrementalTrainingDataChannelOutput... incrementalTrainingDataChannels);

        /**
         * <p>
         * Information about the incremental training data channels used to create this version of the trained model.
         * This includes details about the base model that was used for incremental training and the channel
         * configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #incrementalTrainingDataChannels(List<IncrementalTrainingDataChannelOutput>)}.
         * 
         * @param incrementalTrainingDataChannels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannelOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalTrainingDataChannels(java.util.Collection<IncrementalTrainingDataChannelOutput>)
         */
        Builder incrementalTrainingDataChannels(
                Consumer<IncrementalTrainingDataChannelOutput.Builder>... incrementalTrainingDataChannels);

        /**
         * <p>
         * The name of the trained model.
         * </p>
         * 
         * @param name
         *        The name of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the trained model.
         * </p>
         * 
         * @param description
         *        The description of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the trained model.
         * </p>
         * 
         * @param status
         *        The status of the trained model.
         * @see TrainedModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the trained model.
         * </p>
         * 
         * @param status
         *        The status of the trained model.
         * @see TrainedModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelStatus
         */
        Builder status(TrainedModelStatus status);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * @param statusDetails
         *        The new value for the StatusDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(StatusDetails statusDetails);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StatusDetails.Builder} avoiding the need
         * to create one manually via {@link StatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #statusDetails(StatusDetails)}.
         * 
         * @param statusDetails
         *        a consumer that will call methods on {@link StatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusDetails(StatusDetails)
         */
        default Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return statusDetails(StatusDetails.builder().applyMutation(statusDetails).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create the
         * trained model.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association that was used to create
         *        the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);

        /**
         * <p>
         * The EC2 resource configuration that was used to create the trained model.
         * </p>
         * 
         * @param resourceConfig
         *        The EC2 resource configuration that was used to create the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(ResourceConfig resourceConfig);

        /**
         * <p>
         * The EC2 resource configuration that was used to create the trained model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceConfig.Builder} avoiding the need
         * to create one manually via {@link ResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceConfig(ResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link ResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(ResourceConfig)
         */
        default Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return resourceConfig(ResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * The input mode that was used for accessing the training data when this trained model was created. This
         * indicates how the training data was made available to the training algorithm.
         * </p>
         * 
         * @param trainingInputMode
         *        The input mode that was used for accessing the training data when this trained model was created. This
         *        indicates how the training data was made available to the training algorithm.
         * @see TrainingInputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInputMode
         */
        Builder trainingInputMode(String trainingInputMode);

        /**
         * <p>
         * The input mode that was used for accessing the training data when this trained model was created. This
         * indicates how the training data was made available to the training algorithm.
         * </p>
         * 
         * @param trainingInputMode
         *        The input mode that was used for accessing the training data when this trained model was created. This
         *        indicates how the training data was made available to the training algorithm.
         * @see TrainingInputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInputMode
         */
        Builder trainingInputMode(TrainingInputMode trainingInputMode);

        /**
         * <p>
         * The stopping condition that was used to terminate model training.
         * </p>
         * 
         * @param stoppingCondition
         *        The stopping condition that was used to terminate model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * <p>
         * The stopping condition that was used to terminate model training.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoppingCondition.Builder} avoiding the
         * need to create one manually via {@link StoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * The status of the model metrics.
         * </p>
         * 
         * @param metricsStatus
         *        The status of the model metrics.
         * @see MetricsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsStatus
         */
        Builder metricsStatus(String metricsStatus);

        /**
         * <p>
         * The status of the model metrics.
         * </p>
         * 
         * @param metricsStatus
         *        The status of the model metrics.
         * @see MetricsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsStatus
         */
        Builder metricsStatus(MetricsStatus metricsStatus);

        /**
         * <p>
         * Details about the metrics status for the trained model.
         * </p>
         * 
         * @param metricsStatusDetails
         *        Details about the metrics status for the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsStatusDetails(String metricsStatusDetails);

        /**
         * <p>
         * The logs status for the trained model.
         * </p>
         * 
         * @param logsStatus
         *        The logs status for the trained model.
         * @see LogsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsStatus
         */
        Builder logsStatus(String logsStatus);

        /**
         * <p>
         * The logs status for the trained model.
         * </p>
         * 
         * @param logsStatus
         *        The logs status for the trained model.
         * @see LogsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsStatus
         */
        Builder logsStatus(LogsStatus logsStatus);

        /**
         * <p>
         * Details about the logs status for the trained model.
         * </p>
         * 
         * @param logsStatusDetails
         *        Details about the logs status for the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsStatusDetails(String logsStatusDetails);

        /**
         * <p>
         * Information about the training image container.
         * </p>
         * 
         * @param trainingContainerImageDigest
         *        Information about the training image container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingContainerImageDigest(String trainingContainerImageDigest);

        /**
         * <p>
         * The time at which the trained model was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the trained model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the trained model was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the trained model was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The hyperparameters that were used to create the trained model.
         * </p>
         * 
         * @param hyperparameters
         *        The hyperparameters that were used to create the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperparameters(Map<String, String> hyperparameters);

        /**
         * <p>
         * The EC2 environment that was used to create the trained model.
         * </p>
         * 
         * @param environment
         *        The EC2 environment that was used to create the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in
         * the trained ML model and associated data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
         *        data in the trained ML model and associated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you applied to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to
         *        be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The data channels that were used for the trained model.
         * </p>
         * 
         * @param dataChannels
         *        The data channels that were used for the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataChannels(Collection<ModelTrainingDataChannel> dataChannels);

        /**
         * <p>
         * The data channels that were used for the trained model.
         * </p>
         * 
         * @param dataChannels
         *        The data channels that were used for the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataChannels(ModelTrainingDataChannel... dataChannels);

        /**
         * <p>
         * The data channels that were used for the trained model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel.Builder#build()} is called
         * immediately and its result is passed to {@link #dataChannels(List<ModelTrainingDataChannel>)}.
         * 
         * @param dataChannels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataChannels(java.util.Collection<ModelTrainingDataChannel>)
         */
        Builder dataChannels(Consumer<ModelTrainingDataChannel.Builder>... dataChannels);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String collaborationIdentifier;

        private String trainedModelArn;

        private String versionIdentifier;

        private List<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels = DefaultSdkAutoConstructList
                .getInstance();

        private String name;

        private String description;

        private String status;

        private StatusDetails statusDetails;

        private String configuredModelAlgorithmAssociationArn;

        private ResourceConfig resourceConfig;

        private String trainingInputMode;

        private StoppingCondition stoppingCondition;

        private String metricsStatus;

        private String metricsStatusDetails;

        private String logsStatus;

        private String logsStatusDetails;

        private String trainingContainerImageDigest;

        private Instant createTime;

        private Instant updateTime;

        private Map<String, String> hyperparameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<ModelTrainingDataChannel> dataChannels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrainedModelResponse model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            collaborationIdentifier(model.collaborationIdentifier);
            trainedModelArn(model.trainedModelArn);
            versionIdentifier(model.versionIdentifier);
            incrementalTrainingDataChannels(model.incrementalTrainingDataChannels);
            name(model.name);
            description(model.description);
            status(model.status);
            statusDetails(model.statusDetails);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            resourceConfig(model.resourceConfig);
            trainingInputMode(model.trainingInputMode);
            stoppingCondition(model.stoppingCondition);
            metricsStatus(model.metricsStatus);
            metricsStatusDetails(model.metricsStatusDetails);
            logsStatus(model.logsStatus);
            logsStatusDetails(model.logsStatusDetails);
            trainingContainerImageDigest(model.trainingContainerImageDigest);
            createTime(model.createTime);
            updateTime(model.updateTime);
            hyperparameters(model.hyperparameters);
            environment(model.environment);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
            dataChannels(model.dataChannels);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getVersionIdentifier() {
            return versionIdentifier;
        }

        public final void setVersionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
        }

        @Override
        public final Builder versionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
            return this;
        }

        public final List<IncrementalTrainingDataChannelOutput.Builder> getIncrementalTrainingDataChannels() {
            List<IncrementalTrainingDataChannelOutput.Builder> result = IncrementalTrainingDataChannelsOutputCopier
                    .copyToBuilder(this.incrementalTrainingDataChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncrementalTrainingDataChannels(
                Collection<IncrementalTrainingDataChannelOutput.BuilderImpl> incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels = IncrementalTrainingDataChannelsOutputCopier
                    .copyFromBuilder(incrementalTrainingDataChannels);
        }

        @Override
        public final Builder incrementalTrainingDataChannels(
                Collection<IncrementalTrainingDataChannelOutput> incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels = IncrementalTrainingDataChannelsOutputCopier
                    .copy(incrementalTrainingDataChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incrementalTrainingDataChannels(
                IncrementalTrainingDataChannelOutput... incrementalTrainingDataChannels) {
            incrementalTrainingDataChannels(Arrays.asList(incrementalTrainingDataChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incrementalTrainingDataChannels(
                Consumer<IncrementalTrainingDataChannelOutput.Builder>... incrementalTrainingDataChannels) {
            incrementalTrainingDataChannels(Stream.of(incrementalTrainingDataChannels)
                    .map(c -> IncrementalTrainingDataChannelOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return statusDetails != null ? statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final String getTrainingInputMode() {
            return trainingInputMode;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        @Override
        public final Builder trainingInputMode(TrainingInputMode trainingInputMode) {
            this.trainingInputMode(trainingInputMode == null ? null : trainingInputMode.toString());
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final String getMetricsStatus() {
            return metricsStatus;
        }

        public final void setMetricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
        }

        @Override
        public final Builder metricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
            return this;
        }

        @Override
        public final Builder metricsStatus(MetricsStatus metricsStatus) {
            this.metricsStatus(metricsStatus == null ? null : metricsStatus.toString());
            return this;
        }

        public final String getMetricsStatusDetails() {
            return metricsStatusDetails;
        }

        public final void setMetricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
        }

        @Override
        public final Builder metricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
            return this;
        }

        public final String getLogsStatus() {
            return logsStatus;
        }

        public final void setLogsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
        }

        @Override
        public final Builder logsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
            return this;
        }

        @Override
        public final Builder logsStatus(LogsStatus logsStatus) {
            this.logsStatus(logsStatus == null ? null : logsStatus.toString());
            return this;
        }

        public final String getLogsStatusDetails() {
            return logsStatusDetails;
        }

        public final void setLogsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
        }

        @Override
        public final Builder logsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
            return this;
        }

        public final String getTrainingContainerImageDigest() {
            return trainingContainerImageDigest;
        }

        public final void setTrainingContainerImageDigest(String trainingContainerImageDigest) {
            this.trainingContainerImageDigest = trainingContainerImageDigest;
        }

        @Override
        public final Builder trainingContainerImageDigest(String trainingContainerImageDigest) {
            this.trainingContainerImageDigest = trainingContainerImageDigest;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Map<String, String> getHyperparameters() {
            if (hyperparameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperparameters;
        }

        public final void setHyperparameters(Map<String, String> hyperparameters) {
            this.hyperparameters = HyperParametersCopier.copy(hyperparameters);
        }

        @Override
        public final Builder hyperparameters(Map<String, String> hyperparameters) {
            this.hyperparameters = HyperParametersCopier.copy(hyperparameters);
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentCopier.copy(environment);
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<ModelTrainingDataChannel.Builder> getDataChannels() {
            List<ModelTrainingDataChannel.Builder> result = ModelTrainingDataChannelsCopier.copyToBuilder(this.dataChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataChannels(Collection<ModelTrainingDataChannel.BuilderImpl> dataChannels) {
            this.dataChannels = ModelTrainingDataChannelsCopier.copyFromBuilder(dataChannels);
        }

        @Override
        public final Builder dataChannels(Collection<ModelTrainingDataChannel> dataChannels) {
            this.dataChannels = ModelTrainingDataChannelsCopier.copy(dataChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataChannels(ModelTrainingDataChannel... dataChannels) {
            dataChannels(Arrays.asList(dataChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataChannels(Consumer<ModelTrainingDataChannel.Builder>... dataChannels) {
            dataChannels(Stream.of(dataChannels).map(c -> ModelTrainingDataChannel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetTrainedModelResponse build() {
            return new GetTrainedModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
