/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrainedModelInferenceJobResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetTrainedModelInferenceJobResponse.Builder, GetTrainedModelInferenceJobResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetTrainedModelInferenceJobResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetTrainedModelInferenceJobResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("trainedModelInferenceJobArn")
            .getter(getter(GetTrainedModelInferenceJobResponse::trainedModelInferenceJobArn))
            .setter(setter(Builder::trainedModelInferenceJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelInferenceJobArn")
                    .build()).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(GetTrainedModelInferenceJobResponse::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTrainedModelInferenceJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTrainedModelInferenceJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(GetTrainedModelInferenceJobResponse::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> TRAINED_MODEL_VERSION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("trainedModelVersionIdentifier")
            .getter(getter(GetTrainedModelInferenceJobResponse::trainedModelVersionIdentifier))
            .setter(setter(Builder::trainedModelVersionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelVersionIdentifier")
                    .build()).build();

    private static final SdkField<InferenceResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<InferenceResourceConfig> builder(MarshallingType.SDK_POJO).memberName("resourceConfig")
            .getter(getter(GetTrainedModelInferenceJobResponse::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(InferenceResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()).build();

    private static final SdkField<InferenceOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(GetTrainedModelInferenceJobResponse::outputConfiguration))
            .setter(setter(Builder::outputConfiguration)).constructor(InferenceOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(GetTrainedModelInferenceJobResponse::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<ModelInferenceDataSource> DATA_SOURCE_FIELD = SdkField
            .<ModelInferenceDataSource> builder(MarshallingType.SDK_POJO).memberName("dataSource")
            .getter(getter(GetTrainedModelInferenceJobResponse::dataSource)).setter(setter(Builder::dataSource))
            .constructor(ModelInferenceDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<InferenceContainerExecutionParameters> CONTAINER_EXECUTION_PARAMETERS_FIELD = SdkField
            .<InferenceContainerExecutionParameters> builder(MarshallingType.SDK_POJO)
            .memberName("containerExecutionParameters")
            .getter(getter(GetTrainedModelInferenceJobResponse::containerExecutionParameters))
            .setter(setter(Builder::containerExecutionParameters))
            .constructor(InferenceContainerExecutionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerExecutionParameters")
                    .build()).build();

    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField
            .<StatusDetails> builder(MarshallingType.SDK_POJO).memberName("statusDetails")
            .getter(getter(GetTrainedModelInferenceJobResponse::statusDetails)).setter(setter(Builder::statusDetails))
            .constructor(StatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetTrainedModelInferenceJobResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> INFERENCE_CONTAINER_IMAGE_DIGEST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("inferenceContainerImageDigest")
            .getter(getter(GetTrainedModelInferenceJobResponse::inferenceContainerImageDigest))
            .setter(setter(Builder::inferenceContainerImageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceContainerImageDigest")
                    .build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environment")
            .getter(getter(GetTrainedModelInferenceJobResponse::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(GetTrainedModelInferenceJobResponse::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> METRICS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsStatus").getter(getter(GetTrainedModelInferenceJobResponse::metricsStatusAsString))
            .setter(setter(Builder::metricsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatus").build()).build();

    private static final SdkField<String> METRICS_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsStatusDetails").getter(getter(GetTrainedModelInferenceJobResponse::metricsStatusDetails))
            .setter(setter(Builder::metricsStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatusDetails").build())
            .build();

    private static final SdkField<String> LOGS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logsStatus").getter(getter(GetTrainedModelInferenceJobResponse::logsStatusAsString))
            .setter(setter(Builder::logsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatus").build()).build();

    private static final SdkField<String> LOGS_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logsStatusDetails").getter(getter(GetTrainedModelInferenceJobResponse::logsStatusDetails))
            .setter(setter(Builder::logsStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatusDetails").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetTrainedModelInferenceJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, TRAINED_MODEL_ARN_FIELD, TRAINED_MODEL_VERSION_IDENTIFIER_FIELD, RESOURCE_CONFIG_FIELD,
            OUTPUT_CONFIGURATION_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, DATA_SOURCE_FIELD, CONTAINER_EXECUTION_PARAMETERS_FIELD,
            STATUS_DETAILS_FIELD, DESCRIPTION_FIELD, INFERENCE_CONTAINER_IMAGE_DIGEST_FIELD, ENVIRONMENT_FIELD,
            KMS_KEY_ARN_FIELD, METRICS_STATUS_FIELD, METRICS_STATUS_DETAILS_FIELD, LOGS_STATUS_FIELD, LOGS_STATUS_DETAILS_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createTime;

    private final Instant updateTime;

    private final String trainedModelInferenceJobArn;

    private final String configuredModelAlgorithmAssociationArn;

    private final String name;

    private final String status;

    private final String trainedModelArn;

    private final String trainedModelVersionIdentifier;

    private final InferenceResourceConfig resourceConfig;

    private final InferenceOutputConfiguration outputConfiguration;

    private final String membershipIdentifier;

    private final ModelInferenceDataSource dataSource;

    private final InferenceContainerExecutionParameters containerExecutionParameters;

    private final StatusDetails statusDetails;

    private final String description;

    private final String inferenceContainerImageDigest;

    private final Map<String, String> environment;

    private final String kmsKeyArn;

    private final String metricsStatus;

    private final String metricsStatusDetails;

    private final String logsStatus;

    private final String logsStatusDetails;

    private final Map<String, String> tags;

    private GetTrainedModelInferenceJobResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.trainedModelInferenceJobArn = builder.trainedModelInferenceJobArn;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.name = builder.name;
        this.status = builder.status;
        this.trainedModelArn = builder.trainedModelArn;
        this.trainedModelVersionIdentifier = builder.trainedModelVersionIdentifier;
        this.resourceConfig = builder.resourceConfig;
        this.outputConfiguration = builder.outputConfiguration;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.dataSource = builder.dataSource;
        this.containerExecutionParameters = builder.containerExecutionParameters;
        this.statusDetails = builder.statusDetails;
        this.description = builder.description;
        this.inferenceContainerImageDigest = builder.inferenceContainerImageDigest;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.metricsStatus = builder.metricsStatus;
        this.metricsStatusDetails = builder.metricsStatusDetails;
        this.logsStatus = builder.logsStatus;
        this.logsStatusDetails = builder.logsStatusDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The time at which the trained model inference job was created.
     * </p>
     * 
     * @return The time at which the trained model inference job was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the trained model inference job was updated.
     * </p>
     * 
     * @return The most recent time at which the trained model inference job was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model inference job.
     */
    public final String trainedModelInferenceJobArn() {
        return trainedModelInferenceJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association that was used for the trained model
     * inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association that was used for the
     *         trained model inference job.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    /**
     * <p>
     * The name of the trained model inference job.
     * </p>
     * 
     * @return The name of the trained model inference job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelInferenceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model inference job.
     * @see TrainedModelInferenceJobStatus
     */
    public final TrainedModelInferenceJobStatus status() {
        return TrainedModelInferenceJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelInferenceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model inference job.
     * @see TrainedModelInferenceJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the trained model that was used for the trained model inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the trained model that was used for the trained model inference job.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The version identifier of the trained model used for this inference job. This identifies the specific version of
     * the trained model that was used to generate the inference results.
     * </p>
     * 
     * @return The version identifier of the trained model used for this inference job. This identifies the specific
     *         version of the trained model that was used to generate the inference results.
     */
    public final String trainedModelVersionIdentifier() {
        return trainedModelVersionIdentifier;
    }

    /**
     * <p>
     * The resource configuration information for the trained model inference job.
     * </p>
     * 
     * @return The resource configuration information for the trained model inference job.
     */
    public final InferenceResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * The output configuration information for the trained model inference job.
     * </p>
     * 
     * @return The output configuration information for the trained model inference job.
     */
    public final InferenceOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * The membership ID of the membership that contains the trained model inference job.
     * </p>
     * 
     * @return The membership ID of the membership that contains the trained model inference job.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The data source that was used for the trained model inference job.
     * </p>
     * 
     * @return The data source that was used for the trained model inference job.
     */
    public final ModelInferenceDataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The execution parameters for the model inference job container.
     * </p>
     * 
     * @return The execution parameters for the model inference job container.
     */
    public final InferenceContainerExecutionParameters containerExecutionParameters() {
        return containerExecutionParameters;
    }

    /**
     * Returns the value of the StatusDetails property for this object.
     * 
     * @return The value of the StatusDetails property for this object.
     */
    public final StatusDetails statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The description of the trained model inference job.
     * </p>
     * 
     * @return The description of the trained model inference job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Information about the training container image.
     * </p>
     * 
     * @return Information about the training container image.
     */
    public final String inferenceContainerImageDigest() {
        return inferenceContainerImageDigest;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the Docker container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The environment variables to set in the Docker container.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the
     * ML inference job and associated data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
     *         data in the ML inference job and associated data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The metrics status for the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsStatus}
     * will return {@link MetricsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricsStatusAsString}.
     * </p>
     * 
     * @return The metrics status for the trained model inference job.
     * @see MetricsStatus
     */
    public final MetricsStatus metricsStatus() {
        return MetricsStatus.fromValue(metricsStatus);
    }

    /**
     * <p>
     * The metrics status for the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsStatus}
     * will return {@link MetricsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricsStatusAsString}.
     * </p>
     * 
     * @return The metrics status for the trained model inference job.
     * @see MetricsStatus
     */
    public final String metricsStatusAsString() {
        return metricsStatus;
    }

    /**
     * <p>
     * Details about the metrics status for the trained model inference job.
     * </p>
     * 
     * @return Details about the metrics status for the trained model inference job.
     */
    public final String metricsStatusDetails() {
        return metricsStatusDetails;
    }

    /**
     * <p>
     * The logs status for the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logsStatus} will
     * return {@link LogsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logsStatusAsString}.
     * </p>
     * 
     * @return The logs status for the trained model inference job.
     * @see LogsStatus
     */
    public final LogsStatus logsStatus() {
        return LogsStatus.fromValue(logsStatus);
    }

    /**
     * <p>
     * The logs status for the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logsStatus} will
     * return {@link LogsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logsStatusAsString}.
     * </p>
     * 
     * @return The logs status for the trained model inference job.
     * @see LogsStatus
     */
    public final String logsStatusAsString() {
        return logsStatus;
    }

    /**
     * <p>
     * Details about the logs status for the trained model inference job.
     * </p>
     * 
     * @return Details about the logs status for the trained model inference job.
     */
    public final String logsStatusDetails() {
        return logsStatusDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
     * consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the
     * limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user
     *         tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelInferenceJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(containerExecutionParameters());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceContainerImageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(logsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrainedModelInferenceJobResponse)) {
            return false;
        }
        GetTrainedModelInferenceJobResponse other = (GetTrainedModelInferenceJobResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(trainedModelInferenceJobArn(), other.trainedModelInferenceJobArn())
                && Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(trainedModelVersionIdentifier(), other.trainedModelVersionIdentifier())
                && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(outputConfiguration(), other.outputConfiguration())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(containerExecutionParameters(), other.containerExecutionParameters())
                && Objects.equals(statusDetails(), other.statusDetails()) && Objects.equals(description(), other.description())
                && Objects.equals(inferenceContainerImageDigest(), other.inferenceContainerImageDigest())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(metricsStatusAsString(), other.metricsStatusAsString())
                && Objects.equals(metricsStatusDetails(), other.metricsStatusDetails())
                && Objects.equals(logsStatusAsString(), other.logsStatusAsString())
                && Objects.equals(logsStatusDetails(), other.logsStatusDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTrainedModelInferenceJobResponse").add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).add("TrainedModelInferenceJobArn", trainedModelInferenceJobArn())
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn()).add("Name", name())
                .add("Status", statusAsString()).add("TrainedModelArn", trainedModelArn())
                .add("TrainedModelVersionIdentifier", trainedModelVersionIdentifier()).add("ResourceConfig", resourceConfig())
                .add("OutputConfiguration", outputConfiguration()).add("MembershipIdentifier", membershipIdentifier())
                .add("DataSource", dataSource()).add("ContainerExecutionParameters", containerExecutionParameters())
                .add("StatusDetails", statusDetails()).add("Description", description())
                .add("InferenceContainerImageDigest", inferenceContainerImageDigest())
                .add("Environment", hasEnvironment() ? environment() : null).add("KmsKeyArn", kmsKeyArn())
                .add("MetricsStatus", metricsStatusAsString()).add("MetricsStatusDetails", metricsStatusDetails())
                .add("LogsStatus", logsStatusAsString()).add("LogsStatusDetails", logsStatusDetails())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "trainedModelInferenceJobArn":
            return Optional.ofNullable(clazz.cast(trainedModelInferenceJobArn()));
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "trainedModelVersionIdentifier":
            return Optional.ofNullable(clazz.cast(trainedModelVersionIdentifier()));
        case "resourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "containerExecutionParameters":
            return Optional.ofNullable(clazz.cast(containerExecutionParameters()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "inferenceContainerImageDigest":
            return Optional.ofNullable(clazz.cast(inferenceContainerImageDigest()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "metricsStatus":
            return Optional.ofNullable(clazz.cast(metricsStatusAsString()));
        case "metricsStatusDetails":
            return Optional.ofNullable(clazz.cast(metricsStatusDetails()));
        case "logsStatus":
            return Optional.ofNullable(clazz.cast(logsStatusAsString()));
        case "logsStatusDetails":
            return Optional.ofNullable(clazz.cast(logsStatusDetails()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("trainedModelInferenceJobArn", TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("trainedModelVersionIdentifier", TRAINED_MODEL_VERSION_IDENTIFIER_FIELD);
        map.put("resourceConfig", RESOURCE_CONFIG_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        map.put("containerExecutionParameters", CONTAINER_EXECUTION_PARAMETERS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inferenceContainerImageDigest", INFERENCE_CONTAINER_IMAGE_DIGEST_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("metricsStatus", METRICS_STATUS_FIELD);
        map.put("metricsStatusDetails", METRICS_STATUS_DETAILS_FIELD);
        map.put("logsStatus", LOGS_STATUS_FIELD);
        map.put("logsStatusDetails", LOGS_STATUS_DETAILS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTrainedModelInferenceJobResponse, T> g) {
        return obj -> g.apply((GetTrainedModelInferenceJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTrainedModelInferenceJobResponse> {
        /**
         * <p>
         * The time at which the trained model inference job was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the trained model inference job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the trained model inference job was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the trained model inference job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model inference job.
         * </p>
         * 
         * @param trainedModelInferenceJobArn
         *        The Amazon Resource Name (ARN) of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelInferenceJobArn(String trainedModelInferenceJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association that was used for the trained
         * model inference job.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association that was used for the
         *        trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);

        /**
         * <p>
         * The name of the trained model inference job.
         * </p>
         * 
         * @param name
         *        The name of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the trained model inference job.
         * </p>
         * 
         * @param status
         *        The status of the trained model inference job.
         * @see TrainedModelInferenceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelInferenceJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the trained model inference job.
         * </p>
         * 
         * @param status
         *        The status of the trained model inference job.
         * @see TrainedModelInferenceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelInferenceJobStatus
         */
        Builder status(TrainedModelInferenceJobStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the trained model that was used for the trained model inference job.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) for the trained model that was used for the trained model inference
         *        job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The version identifier of the trained model used for this inference job. This identifies the specific version
         * of the trained model that was used to generate the inference results.
         * </p>
         * 
         * @param trainedModelVersionIdentifier
         *        The version identifier of the trained model used for this inference job. This identifies the specific
         *        version of the trained model that was used to generate the inference results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelVersionIdentifier(String trainedModelVersionIdentifier);

        /**
         * <p>
         * The resource configuration information for the trained model inference job.
         * </p>
         * 
         * @param resourceConfig
         *        The resource configuration information for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(InferenceResourceConfig resourceConfig);

        /**
         * <p>
         * The resource configuration information for the trained model inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceResourceConfig.Builder} avoiding
         * the need to create one manually via {@link InferenceResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceResourceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceConfig(InferenceResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link InferenceResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(InferenceResourceConfig)
         */
        default Builder resourceConfig(Consumer<InferenceResourceConfig.Builder> resourceConfig) {
            return resourceConfig(InferenceResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * The output configuration information for the trained model inference job.
         * </p>
         * 
         * @param outputConfiguration
         *        The output configuration information for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration);

        /**
         * <p>
         * The output configuration information for the trained model inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link InferenceOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfiguration(InferenceOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link InferenceOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(InferenceOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<InferenceOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(InferenceOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }

        /**
         * <p>
         * The membership ID of the membership that contains the trained model inference job.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the membership that contains the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The data source that was used for the trained model inference job.
         * </p>
         * 
         * @param dataSource
         *        The data source that was used for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(ModelInferenceDataSource dataSource);

        /**
         * <p>
         * The data source that was used for the trained model inference job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelInferenceDataSource.Builder}
         * avoiding the need to create one manually via {@link ModelInferenceDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelInferenceDataSource.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSource(ModelInferenceDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link ModelInferenceDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(ModelInferenceDataSource)
         */
        default Builder dataSource(Consumer<ModelInferenceDataSource.Builder> dataSource) {
            return dataSource(ModelInferenceDataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The execution parameters for the model inference job container.
         * </p>
         * 
         * @param containerExecutionParameters
         *        The execution parameters for the model inference job container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerExecutionParameters(InferenceContainerExecutionParameters containerExecutionParameters);

        /**
         * <p>
         * The execution parameters for the model inference job container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceContainerExecutionParameters.Builder} avoiding the need to create one manually via
         * {@link InferenceContainerExecutionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceContainerExecutionParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #containerExecutionParameters(InferenceContainerExecutionParameters)}.
         * 
         * @param containerExecutionParameters
         *        a consumer that will call methods on {@link InferenceContainerExecutionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerExecutionParameters(InferenceContainerExecutionParameters)
         */
        default Builder containerExecutionParameters(
                Consumer<InferenceContainerExecutionParameters.Builder> containerExecutionParameters) {
            return containerExecutionParameters(InferenceContainerExecutionParameters.builder()
                    .applyMutation(containerExecutionParameters).build());
        }

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * @param statusDetails
         *        The new value for the StatusDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(StatusDetails statusDetails);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StatusDetails.Builder} avoiding the need
         * to create one manually via {@link StatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #statusDetails(StatusDetails)}.
         * 
         * @param statusDetails
         *        a consumer that will call methods on {@link StatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusDetails(StatusDetails)
         */
        default Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return statusDetails(StatusDetails.builder().applyMutation(statusDetails).build());
        }

        /**
         * <p>
         * The description of the trained model inference job.
         * </p>
         * 
         * @param description
         *        The description of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the training container image.
         * </p>
         * 
         * @param inferenceContainerImageDigest
         *        Information about the training container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceContainerImageDigest(String inferenceContainerImageDigest);

        /**
         * <p>
         * The environment variables to set in the Docker container.
         * </p>
         * 
         * @param environment
         *        The environment variables to set in the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in
         * the ML inference job and associated data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
         *        data in the ML inference job and associated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The metrics status for the trained model inference job.
         * </p>
         * 
         * @param metricsStatus
         *        The metrics status for the trained model inference job.
         * @see MetricsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsStatus
         */
        Builder metricsStatus(String metricsStatus);

        /**
         * <p>
         * The metrics status for the trained model inference job.
         * </p>
         * 
         * @param metricsStatus
         *        The metrics status for the trained model inference job.
         * @see MetricsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsStatus
         */
        Builder metricsStatus(MetricsStatus metricsStatus);

        /**
         * <p>
         * Details about the metrics status for the trained model inference job.
         * </p>
         * 
         * @param metricsStatusDetails
         *        Details about the metrics status for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsStatusDetails(String metricsStatusDetails);

        /**
         * <p>
         * The logs status for the trained model inference job.
         * </p>
         * 
         * @param logsStatus
         *        The logs status for the trained model inference job.
         * @see LogsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsStatus
         */
        Builder logsStatus(String logsStatus);

        /**
         * <p>
         * The logs status for the trained model inference job.
         * </p>
         * 
         * @param logsStatus
         *        The logs status for the trained model inference job.
         * @see LogsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsStatus
         */
        Builder logsStatus(LogsStatus logsStatus);

        /**
         * <p>
         * Details about the logs status for the trained model inference job.
         * </p>
         * 
         * @param logsStatusDetails
         *        Details about the logs status for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsStatusDetails(String logsStatusDetails);

        /**
         * <p>
         * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you applied to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to
         *        be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String trainedModelInferenceJobArn;

        private String configuredModelAlgorithmAssociationArn;

        private String name;

        private String status;

        private String trainedModelArn;

        private String trainedModelVersionIdentifier;

        private InferenceResourceConfig resourceConfig;

        private InferenceOutputConfiguration outputConfiguration;

        private String membershipIdentifier;

        private ModelInferenceDataSource dataSource;

        private InferenceContainerExecutionParameters containerExecutionParameters;

        private StatusDetails statusDetails;

        private String description;

        private String inferenceContainerImageDigest;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyArn;

        private String metricsStatus;

        private String metricsStatusDetails;

        private String logsStatus;

        private String logsStatusDetails;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrainedModelInferenceJobResponse model) {
            super(model);
            createTime(model.createTime);
            updateTime(model.updateTime);
            trainedModelInferenceJobArn(model.trainedModelInferenceJobArn);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            name(model.name);
            status(model.status);
            trainedModelArn(model.trainedModelArn);
            trainedModelVersionIdentifier(model.trainedModelVersionIdentifier);
            resourceConfig(model.resourceConfig);
            outputConfiguration(model.outputConfiguration);
            membershipIdentifier(model.membershipIdentifier);
            dataSource(model.dataSource);
            containerExecutionParameters(model.containerExecutionParameters);
            statusDetails(model.statusDetails);
            description(model.description);
            inferenceContainerImageDigest(model.inferenceContainerImageDigest);
            environment(model.environment);
            kmsKeyArn(model.kmsKeyArn);
            metricsStatus(model.metricsStatus);
            metricsStatusDetails(model.metricsStatusDetails);
            logsStatus(model.logsStatus);
            logsStatusDetails(model.logsStatusDetails);
            tags(model.tags);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getTrainedModelInferenceJobArn() {
            return trainedModelInferenceJobArn;
        }

        public final void setTrainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
        }

        @Override
        public final Builder trainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelInferenceJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getTrainedModelVersionIdentifier() {
            return trainedModelVersionIdentifier;
        }

        public final void setTrainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
        }

        @Override
        public final Builder trainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
            return this;
        }

        public final InferenceResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(InferenceResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(InferenceResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(InferenceOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final ModelInferenceDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(ModelInferenceDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(ModelInferenceDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final InferenceContainerExecutionParameters.Builder getContainerExecutionParameters() {
            return containerExecutionParameters != null ? containerExecutionParameters.toBuilder() : null;
        }

        public final void setContainerExecutionParameters(
                InferenceContainerExecutionParameters.BuilderImpl containerExecutionParameters) {
            this.containerExecutionParameters = containerExecutionParameters != null ? containerExecutionParameters.build()
                    : null;
        }

        @Override
        public final Builder containerExecutionParameters(InferenceContainerExecutionParameters containerExecutionParameters) {
            this.containerExecutionParameters = containerExecutionParameters;
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return statusDetails != null ? statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInferenceContainerImageDigest() {
            return inferenceContainerImageDigest;
        }

        public final void setInferenceContainerImageDigest(String inferenceContainerImageDigest) {
            this.inferenceContainerImageDigest = inferenceContainerImageDigest;
        }

        @Override
        public final Builder inferenceContainerImageDigest(String inferenceContainerImageDigest) {
            this.inferenceContainerImageDigest = inferenceContainerImageDigest;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = InferenceEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = InferenceEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getMetricsStatus() {
            return metricsStatus;
        }

        public final void setMetricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
        }

        @Override
        public final Builder metricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
            return this;
        }

        @Override
        public final Builder metricsStatus(MetricsStatus metricsStatus) {
            this.metricsStatus(metricsStatus == null ? null : metricsStatus.toString());
            return this;
        }

        public final String getMetricsStatusDetails() {
            return metricsStatusDetails;
        }

        public final void setMetricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
        }

        @Override
        public final Builder metricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
            return this;
        }

        public final String getLogsStatus() {
            return logsStatus;
        }

        public final void setLogsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
        }

        @Override
        public final Builder logsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
            return this;
        }

        @Override
        public final Builder logsStatus(LogsStatus logsStatus) {
            this.logsStatus(logsStatus == null ? null : logsStatus.toString());
            return this;
        }

        public final String getLogsStatusDetails() {
            return logsStatusDetails;
        }

        public final void setLogsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
        }

        @Override
        public final Builder logsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTrainedModelInferenceJobResponse build() {
            return new GetTrainedModelInferenceJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
