/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationMlInputChannelResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetCollaborationMlInputChannelResponse.Builder, GetCollaborationMlInputChannelResponse> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(GetCollaborationMlInputChannelResponse::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier")
            .getter(getter(GetCollaborationMlInputChannelResponse::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mlInputChannelArn").getter(getter(GetCollaborationMlInputChannelResponse::mlInputChannelArn))
            .setter(setter(Builder::mlInputChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetCollaborationMlInputChannelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("configuredModelAlgorithmAssociations")
            .getter(getter(GetCollaborationMlInputChannelResponse::configuredModelAlgorithmAssociations))
            .setter(setter(Builder::configuredModelAlgorithmAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetCollaborationMlInputChannelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField
            .<StatusDetails> builder(MarshallingType.SDK_POJO).memberName("statusDetails")
            .getter(getter(GetCollaborationMlInputChannelResponse::statusDetails)).setter(setter(Builder::statusDetails))
            .constructor(StatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()).build();

    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionInDays").getter(getter(GetCollaborationMlInputChannelResponse::retentionInDays))
            .setter(setter(Builder::retentionInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()).build();

    private static final SdkField<Long> NUMBER_OF_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfRecords").getter(getter(GetCollaborationMlInputChannelResponse::numberOfRecords))
            .setter(setter(Builder::numberOfRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecords").build()).build();

    private static final SdkField<PrivacyBudgets> PRIVACY_BUDGETS_FIELD = SdkField
            .<PrivacyBudgets> builder(MarshallingType.SDK_POJO).memberName("privacyBudgets")
            .getter(getter(GetCollaborationMlInputChannelResponse::privacyBudgets)).setter(setter(Builder::privacyBudgets))
            .constructor(PrivacyBudgets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgets").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCollaborationMlInputChannelResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SyntheticDataConfiguration> SYNTHETIC_DATA_CONFIGURATION_FIELD = SdkField
            .<SyntheticDataConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("syntheticDataConfiguration")
            .getter(getter(GetCollaborationMlInputChannelResponse::syntheticDataConfiguration))
            .setter(setter(Builder::syntheticDataConfiguration))
            .constructor(SyntheticDataConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntheticDataConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetCollaborationMlInputChannelResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetCollaborationMlInputChannelResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorAccountId").getter(getter(GetCollaborationMlInputChannelResponse::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            COLLABORATION_IDENTIFIER_FIELD, ML_INPUT_CHANNEL_ARN_FIELD, NAME_FIELD,
            CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, RETENTION_IN_DAYS_FIELD,
            NUMBER_OF_RECORDS_FIELD, PRIVACY_BUDGETS_FIELD, DESCRIPTION_FIELD, SYNTHETIC_DATA_CONFIGURATION_FIELD,
            CREATE_TIME_FIELD, UPDATE_TIME_FIELD, CREATOR_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String collaborationIdentifier;

    private final String mlInputChannelArn;

    private final String name;

    private final List<String> configuredModelAlgorithmAssociations;

    private final String status;

    private final StatusDetails statusDetails;

    private final Integer retentionInDays;

    private final Long numberOfRecords;

    private final PrivacyBudgets privacyBudgets;

    private final String description;

    private final SyntheticDataConfiguration syntheticDataConfiguration;

    private final Instant createTime;

    private final Instant updateTime;

    private final String creatorAccountId;

    private GetCollaborationMlInputChannelResponse(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.mlInputChannelArn = builder.mlInputChannelArn;
        this.name = builder.name;
        this.configuredModelAlgorithmAssociations = builder.configuredModelAlgorithmAssociations;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.retentionInDays = builder.retentionInDays;
        this.numberOfRecords = builder.numberOfRecords;
        this.privacyBudgets = builder.privacyBudgets;
        this.description = builder.description;
        this.syntheticDataConfiguration = builder.syntheticDataConfiguration;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.creatorAccountId = builder.creatorAccountId;
    }

    /**
     * <p>
     * The membership ID of the membership that contains the ML input channel.
     * </p>
     * 
     * @return The membership ID of the membership that contains the ML input channel.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The collaboration ID of the collaboration that contains the ML input channel.
     * </p>
     * 
     * @return The collaboration ID of the collaboration that contains the ML input channel.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ML input channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ML input channel.
     */
    public final String mlInputChannelArn() {
        return mlInputChannelArn;
    }

    /**
     * <p>
     * The name of the ML input channel.
     * </p>
     * 
     * @return The name of the ML input channel.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfiguredModelAlgorithmAssociations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasConfiguredModelAlgorithmAssociations() {
        return configuredModelAlgorithmAssociations != null
                && !(configuredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configured model algorithm associations that were used to create the ML input channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguredModelAlgorithmAssociations}
     * method.
     * </p>
     * 
     * @return The configured model algorithm associations that were used to create the ML input channel.
     */
    public final List<String> configuredModelAlgorithmAssociations() {
        return configuredModelAlgorithmAssociations;
    }

    /**
     * <p>
     * The status of the ML input channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MLInputChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ML input channel.
     * @see MLInputChannelStatus
     */
    public final MLInputChannelStatus status() {
        return MLInputChannelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the ML input channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MLInputChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ML input channel.
     * @see MLInputChannelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the StatusDetails property for this object.
     * 
     * @return The value of the StatusDetails property for this object.
     */
    public final StatusDetails statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The number of days to retain the data for the ML input channel.
     * </p>
     * 
     * @return The number of days to retain the data for the ML input channel.
     */
    public final Integer retentionInDays() {
        return retentionInDays;
    }

    /**
     * <p>
     * The number of records in the ML input channel.
     * </p>
     * 
     * @return The number of records in the ML input channel.
     */
    public final Long numberOfRecords() {
        return numberOfRecords;
    }

    /**
     * <p>
     * Returns the privacy budgets that control access to this Clean Rooms ML input channel. Use these budgets to
     * monitor and limit resource consumption over specified time periods.
     * </p>
     * 
     * @return Returns the privacy budgets that control access to this Clean Rooms ML input channel. Use these budgets
     *         to monitor and limit resource consumption over specified time periods.
     */
    public final PrivacyBudgets privacyBudgets() {
        return privacyBudgets;
    }

    /**
     * <p>
     * The description of the ML input channel.
     * </p>
     * 
     * @return The description of the ML input channel.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The synthetic data configuration for this ML input channel, including parameters for generating
     * privacy-preserving synthetic data and evaluation scores for measuring the privacy of the generated data.
     * </p>
     * 
     * @return The synthetic data configuration for this ML input channel, including parameters for generating
     *         privacy-preserving synthetic data and evaluation scores for measuring the privacy of the generated data.
     */
    public final SyntheticDataConfiguration syntheticDataConfiguration() {
        return syntheticDataConfiguration;
    }

    /**
     * <p>
     * The time at which the ML input channel was created.
     * </p>
     * 
     * @return The time at which the ML input channel was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the ML input channel was updated.
     * </p>
     * 
     * @return The most recent time at which the ML input channel was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The account ID of the member who created the ML input channel.
     * </p>
     * 
     * @return The account ID of the member who created the ML input channel.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(mlInputChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConfiguredModelAlgorithmAssociations() ? configuredModelAlgorithmAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRecords());
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgets());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(syntheticDataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationMlInputChannelResponse)) {
            return false;
        }
        GetCollaborationMlInputChannelResponse other = (GetCollaborationMlInputChannelResponse) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(mlInputChannelArn(), other.mlInputChannelArn()) && Objects.equals(name(), other.name())
                && hasConfiguredModelAlgorithmAssociations() == other.hasConfiguredModelAlgorithmAssociations()
                && Objects.equals(configuredModelAlgorithmAssociations(), other.configuredModelAlgorithmAssociations())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(retentionInDays(), other.retentionInDays())
                && Objects.equals(numberOfRecords(), other.numberOfRecords())
                && Objects.equals(privacyBudgets(), other.privacyBudgets()) && Objects.equals(description(), other.description())
                && Objects.equals(syntheticDataConfiguration(), other.syntheticDataConfiguration())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(creatorAccountId(), other.creatorAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetCollaborationMlInputChannelResponse")
                .add("MembershipIdentifier", membershipIdentifier())
                .add("CollaborationIdentifier", collaborationIdentifier())
                .add("MlInputChannelArn", mlInputChannelArn())
                .add("Name", name())
                .add("ConfiguredModelAlgorithmAssociations",
                        hasConfiguredModelAlgorithmAssociations() ? configuredModelAlgorithmAssociations() : null)
                .add("Status", statusAsString()).add("StatusDetails", statusDetails()).add("RetentionInDays", retentionInDays())
                .add("NumberOfRecords", numberOfRecords()).add("PrivacyBudgets", privacyBudgets())
                .add("Description", description()).add("SyntheticDataConfiguration", syntheticDataConfiguration())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("CreatorAccountId", creatorAccountId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "mlInputChannelArn":
            return Optional.ofNullable(clazz.cast(mlInputChannelArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "configuredModelAlgorithmAssociations":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociations()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "retentionInDays":
            return Optional.ofNullable(clazz.cast(retentionInDays()));
        case "numberOfRecords":
            return Optional.ofNullable(clazz.cast(numberOfRecords()));
        case "privacyBudgets":
            return Optional.ofNullable(clazz.cast(privacyBudgets()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "syntheticDataConfiguration":
            return Optional.ofNullable(clazz.cast(syntheticDataConfiguration()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "creatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuredModelAlgorithmAssociations", CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("retentionInDays", RETENTION_IN_DAYS_FIELD);
        map.put("numberOfRecords", NUMBER_OF_RECORDS_FIELD);
        map.put("privacyBudgets", PRIVACY_BUDGETS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("syntheticDataConfiguration", SYNTHETIC_DATA_CONFIGURATION_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationMlInputChannelResponse, T> g) {
        return obj -> g.apply((GetCollaborationMlInputChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationMlInputChannelResponse> {
        /**
         * <p>
         * The membership ID of the membership that contains the ML input channel.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the membership that contains the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The collaboration ID of the collaboration that contains the ML input channel.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The collaboration ID of the collaboration that contains the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ML input channel.
         * </p>
         * 
         * @param mlInputChannelArn
         *        The Amazon Resource Name (ARN) of the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlInputChannelArn(String mlInputChannelArn);

        /**
         * <p>
         * The name of the ML input channel.
         * </p>
         * 
         * @param name
         *        The name of the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configured model algorithm associations that were used to create the ML input channel.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociations
         *        The configured model algorithm associations that were used to create the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations);

        /**
         * <p>
         * The configured model algorithm associations that were used to create the ML input channel.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociations
         *        The configured model algorithm associations that were used to create the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociations(String... configuredModelAlgorithmAssociations);

        /**
         * <p>
         * The status of the ML input channel.
         * </p>
         * 
         * @param status
         *        The status of the ML input channel.
         * @see MLInputChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLInputChannelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the ML input channel.
         * </p>
         * 
         * @param status
         *        The status of the ML input channel.
         * @see MLInputChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLInputChannelStatus
         */
        Builder status(MLInputChannelStatus status);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * @param statusDetails
         *        The new value for the StatusDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(StatusDetails statusDetails);

        /**
         * Sets the value of the StatusDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StatusDetails.Builder} avoiding the need
         * to create one manually via {@link StatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #statusDetails(StatusDetails)}.
         * 
         * @param statusDetails
         *        a consumer that will call methods on {@link StatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusDetails(StatusDetails)
         */
        default Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return statusDetails(StatusDetails.builder().applyMutation(statusDetails).build());
        }

        /**
         * <p>
         * The number of days to retain the data for the ML input channel.
         * </p>
         * 
         * @param retentionInDays
         *        The number of days to retain the data for the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionInDays(Integer retentionInDays);

        /**
         * <p>
         * The number of records in the ML input channel.
         * </p>
         * 
         * @param numberOfRecords
         *        The number of records in the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRecords(Long numberOfRecords);

        /**
         * <p>
         * Returns the privacy budgets that control access to this Clean Rooms ML input channel. Use these budgets to
         * monitor and limit resource consumption over specified time periods.
         * </p>
         * 
         * @param privacyBudgets
         *        Returns the privacy budgets that control access to this Clean Rooms ML input channel. Use these
         *        budgets to monitor and limit resource consumption over specified time periods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyBudgets(PrivacyBudgets privacyBudgets);

        /**
         * <p>
         * Returns the privacy budgets that control access to this Clean Rooms ML input channel. Use these budgets to
         * monitor and limit resource consumption over specified time periods.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivacyBudgets.Builder} avoiding the need
         * to create one manually via {@link PrivacyBudgets#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyBudgets.Builder#build()} is called immediately and its
         * result is passed to {@link #privacyBudgets(PrivacyBudgets)}.
         * 
         * @param privacyBudgets
         *        a consumer that will call methods on {@link PrivacyBudgets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privacyBudgets(PrivacyBudgets)
         */
        default Builder privacyBudgets(Consumer<PrivacyBudgets.Builder> privacyBudgets) {
            return privacyBudgets(PrivacyBudgets.builder().applyMutation(privacyBudgets).build());
        }

        /**
         * <p>
         * The description of the ML input channel.
         * </p>
         * 
         * @param description
         *        The description of the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The synthetic data configuration for this ML input channel, including parameters for generating
         * privacy-preserving synthetic data and evaluation scores for measuring the privacy of the generated data.
         * </p>
         * 
         * @param syntheticDataConfiguration
         *        The synthetic data configuration for this ML input channel, including parameters for generating
         *        privacy-preserving synthetic data and evaluation scores for measuring the privacy of the generated
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syntheticDataConfiguration(SyntheticDataConfiguration syntheticDataConfiguration);

        /**
         * <p>
         * The synthetic data configuration for this ML input channel, including parameters for generating
         * privacy-preserving synthetic data and evaluation scores for measuring the privacy of the generated data.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyntheticDataConfiguration.Builder}
         * avoiding the need to create one manually via {@link SyntheticDataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyntheticDataConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #syntheticDataConfiguration(SyntheticDataConfiguration)}.
         * 
         * @param syntheticDataConfiguration
         *        a consumer that will call methods on {@link SyntheticDataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syntheticDataConfiguration(SyntheticDataConfiguration)
         */
        default Builder syntheticDataConfiguration(Consumer<SyntheticDataConfiguration.Builder> syntheticDataConfiguration) {
            return syntheticDataConfiguration(SyntheticDataConfiguration.builder().applyMutation(syntheticDataConfiguration)
                    .build());
        }

        /**
         * <p>
         * The time at which the ML input channel was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the ML input channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the ML input channel was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the ML input channel was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The account ID of the member who created the ML input channel.
         * </p>
         * 
         * @param creatorAccountId
         *        The account ID of the member who created the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String collaborationIdentifier;

        private String mlInputChannelArn;

        private String name;

        private List<String> configuredModelAlgorithmAssociations = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private StatusDetails statusDetails;

        private Integer retentionInDays;

        private Long numberOfRecords;

        private PrivacyBudgets privacyBudgets;

        private String description;

        private SyntheticDataConfiguration syntheticDataConfiguration;

        private Instant createTime;

        private Instant updateTime;

        private String creatorAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationMlInputChannelResponse model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            collaborationIdentifier(model.collaborationIdentifier);
            mlInputChannelArn(model.mlInputChannelArn);
            name(model.name);
            configuredModelAlgorithmAssociations(model.configuredModelAlgorithmAssociations);
            status(model.status);
            statusDetails(model.statusDetails);
            retentionInDays(model.retentionInDays);
            numberOfRecords(model.numberOfRecords);
            privacyBudgets(model.privacyBudgets);
            description(model.description);
            syntheticDataConfiguration(model.syntheticDataConfiguration);
            createTime(model.createTime);
            updateTime(model.updateTime);
            creatorAccountId(model.creatorAccountId);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getMlInputChannelArn() {
            return mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getConfiguredModelAlgorithmAssociations() {
            if (configuredModelAlgorithmAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return configuredModelAlgorithmAssociations;
        }

        public final void setConfiguredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = GetCollaborationMLInputChannelResponseConfiguredModelAlgorithmAssociationsListCopier
                    .copy(configuredModelAlgorithmAssociations);
        }

        @Override
        public final Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = GetCollaborationMLInputChannelResponseConfiguredModelAlgorithmAssociationsListCopier
                    .copy(configuredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(String... configuredModelAlgorithmAssociations) {
            configuredModelAlgorithmAssociations(Arrays.asList(configuredModelAlgorithmAssociations));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MLInputChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return statusDetails != null ? statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Integer getRetentionInDays() {
            return retentionInDays;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final Long getNumberOfRecords() {
            return numberOfRecords;
        }

        public final void setNumberOfRecords(Long numberOfRecords) {
            this.numberOfRecords = numberOfRecords;
        }

        @Override
        public final Builder numberOfRecords(Long numberOfRecords) {
            this.numberOfRecords = numberOfRecords;
            return this;
        }

        public final PrivacyBudgets.Builder getPrivacyBudgets() {
            return privacyBudgets != null ? privacyBudgets.toBuilder() : null;
        }

        public final void setPrivacyBudgets(PrivacyBudgets.BuilderImpl privacyBudgets) {
            this.privacyBudgets = privacyBudgets != null ? privacyBudgets.build() : null;
        }

        @Override
        public final Builder privacyBudgets(PrivacyBudgets privacyBudgets) {
            this.privacyBudgets = privacyBudgets;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SyntheticDataConfiguration.Builder getSyntheticDataConfiguration() {
            return syntheticDataConfiguration != null ? syntheticDataConfiguration.toBuilder() : null;
        }

        public final void setSyntheticDataConfiguration(SyntheticDataConfiguration.BuilderImpl syntheticDataConfiguration) {
            this.syntheticDataConfiguration = syntheticDataConfiguration != null ? syntheticDataConfiguration.build() : null;
        }

        @Override
        public final Builder syntheticDataConfiguration(SyntheticDataConfiguration syntheticDataConfiguration) {
            this.syntheticDataConfiguration = syntheticDataConfiguration;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        @Override
        public GetCollaborationMlInputChannelResponse build() {
            return new GetCollaborationMlInputChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
